/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.consumable;

import dev.xkmc.l2hostility.init.data.LangData;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class BookEverything
extends Item {
    @Nullable
    private static Enchantment getEnch(ItemStack stack) {
        String name = stack.m_41786_().getString();
        try {
            ResourceLocation rl = new ResourceLocation(name.trim());
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(rl)) {
                return null;
            }
            return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rl);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean allow(Enchantment ench) {
        if (ench.m_6591_() || !ench.isAllowedOnBooks() || !ench.m_6592_()) {
            return false;
        }
        return ench.m_6175_(ench.m_6586_()) >= ench.m_6183_(ench.m_6586_());
    }

    public static int cost(Enchantment ench) {
        return Math.max(ench.m_6586_(), ench.m_6175_(ench.m_6586_()) / 10);
    }

    public BookEverything(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.m_5776_()) {
                ItemStack result = new ItemStack((ItemLike)Items.f_42690_);
                ListTag listtag = EnchantedBookItem.m_41163_((ItemStack)result);
                for (Map.Entry e : ForgeRegistries.ENCHANTMENTS.getEntries()) {
                    if (!BookEverything.allow((Enchantment)e.getValue())) continue;
                    listtag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)((ResourceKey)e.getKey()).m_135782_(), (int)((Enchantment)e.getValue()).m_6586_()));
                }
                result.m_41784_().m_128365_("StoredEnchantments", (Tag)listtag);
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    return InteractionResultHolder.m_19090_((Object)result);
                }
                player.m_150109_().m_150079_(result);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        Enchantment ench = BookEverything.getEnch(stack);
        if (ench == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!BookEverything.allow(ench)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int cost = BookEverything.cost(ench);
        if (player.f_36078_ < cost) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!level.m_5776_()) {
            player.m_6749_(-cost);
            EnchantmentInstance ins = new EnchantmentInstance(ench, ench.m_6586_());
            ItemStack result = EnchantedBookItem.m_41161_((EnchantmentInstance)ins);
            player.m_150109_().m_150079_(result);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.ITEM_BOOK_EVERYTHING_USE.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        list.add((Component)LangData.ITEM_BOOK_EVERYTHING_SHIFT.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
        Enchantment e = BookEverything.getEnch(stack);
        if (e == null) {
            list.add((Component)LangData.ITEM_BOOK_EVERYTHING_INVALID.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        } else if (BookEverything.allow(e)) {
            int cost = BookEverything.cost(e);
            list.add((Component)LangData.ITEM_BOOK_EVERYTHING_READY.get(e.m_44700_(e.m_6586_()), cost).m_130940_(ChatFormatting.GREEN));
        } else {
            list.add((Component)LangData.ITEM_BOOK_EVERYTHING_FORBIDDEN.get(e.m_44700_(e.m_6586_())).m_130940_(ChatFormatting.RED));
        }
    }
}

