/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.beacon;

import com.google.common.collect.Lists;
import dev.xkmc.l2hostility.content.item.beacon.HostilityBeaconBlockEntity;
import dev.xkmc.l2hostility.content.item.beacon.HostilityBeaconMenu;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2library.util.Proxy;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HostilityBeaconScreen
extends AbstractContainerScreen<HostilityBeaconMenu>
implements ContainerListener {
    static final ResourceLocation BEACON_LOCATION = new ResourceLocation("l2hostility", "textures/gui/container/beacon.png");
    private static final Component PRIMARY_EFFECT_LABEL = Component.m_237115_((String)"block.minecraft.beacon.primary");
    private final List<BeaconButton> beaconButtons = Lists.newArrayList();
    int primary = -1;

    public HostilityBeaconScreen(HostilityBeaconMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 230;
        this.f_97727_ = 219;
        menu.m_38893_(this);
    }

    public void m_7934_(AbstractContainerMenu self, int index, ItemStack stack) {
    }

    public void m_142153_(AbstractContainerMenu self, int index, int value) {
        this.primary = ((HostilityBeaconMenu)this.f_97732_).getPrimaryEffect();
    }

    private <T extends AbstractWidget> void addBeaconButton(T btn) {
        this.m_142416_((GuiEventListener)btn);
        this.beaconButtons.add((BeaconButton)btn);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.beaconButtons.clear();
        this.addBeaconButton(new BeaconConfirmButton(this.f_97735_ + 164, this.f_97736_ + 107));
        this.addBeaconButton(new BeaconCancelButton(this.f_97735_ + 190, this.f_97736_ + 107));
        for (int i = 0; i <= 2; ++i) {
            int n = HostilityBeaconBlockEntity.BEACON_EFFECTS[i].length;
            int w = n * 22 + (n - 1) * 2;
            for (int j = 0; j < n; ++j) {
                BeaconPowerButton btn = new BeaconPowerButton(this.f_97735_ + 76 + j * 24 - w / 2, this.f_97736_ + 22 + i * 25, i * 2 + j, i);
                btn.f_93623_ = false;
                this.addBeaconButton(btn);
            }
        }
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateButtons();
    }

    void updateButtons() {
        int i = ((HostilityBeaconMenu)this.f_97732_).getLevels();
        this.beaconButtons.forEach(p_169615_ -> p_169615_.updateStatus(i));
    }

    protected void m_280003_(GuiGraphics p_283369_, int p_282699_, int p_281296_) {
        p_283369_.m_280653_(this.f_96547_, PRIMARY_EFFECT_LABEL, 62, 10, 0xE0E0E0);
    }

    protected void m_7286_(GuiGraphics p_282454_, float p_282185_, int p_282362_, int p_282987_) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        p_282454_.m_280218_(BEACON_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        p_282454_.m_280168_().m_85836_();
        p_282454_.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        p_282454_.m_280480_(new ItemStack(LHItems.CHAOS_INGOT), i + 42 + 44, j + 109);
        p_282454_.m_280480_(new ItemStack(LHItems.MIRACLE_INGOT), i + 42 + 66, j + 109);
        p_282454_.m_280168_().m_85849_();
    }

    public void m_88315_(GuiGraphics p_283062_, int p_282876_, int p_282015_, float p_281395_) {
        this.m_280273_(p_283062_);
        super.m_88315_(p_283062_, p_282876_, p_282015_, p_281395_);
        this.m_280072_(p_283062_, p_282876_, p_282015_);
    }

    protected boolean click(int btn) {
        if (((HostilityBeaconMenu)this.f_97732_).m_6366_((Player)Proxy.getClientPlayer(), btn) && Minecraft.m_91087_().f_91072_ != null) {
            Minecraft.m_91087_().f_91072_.m_105208_(((HostilityBeaconMenu)this.f_97732_).f_38840_, btn);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface BeaconButton {
        public void updateStatus(int var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    class BeaconConfirmButton
    extends BeaconSpriteScreenButton {
        public BeaconConfirmButton(int p_97992_, int p_97993_) {
            super(p_97992_, p_97993_, 90, 220, CommonComponents.f_130655_);
        }

        public void m_5691_() {
            HostilityBeaconScreen.this.click(HostilityBeaconScreen.this.primary);
            ((HostilityBeaconScreen)HostilityBeaconScreen.this).f_96541_.f_91074_.m_6915_();
        }

        @Override
        public void updateStatus(int p_169638_) {
            this.f_93623_ = ((HostilityBeaconMenu)HostilityBeaconScreen.this.f_97732_).hasPayment() && HostilityBeaconScreen.this.primary != -1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class BeaconCancelButton
    extends BeaconSpriteScreenButton {
        public BeaconCancelButton(int p_97982_, int p_97983_) {
            super(p_97982_, p_97983_, 112, 220, CommonComponents.f_130656_);
        }

        public void m_5691_() {
            ((HostilityBeaconScreen)HostilityBeaconScreen.this).f_96541_.f_91074_.m_6915_();
        }

        @Override
        public void updateStatus(int p_169636_) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class BeaconPowerButton
    extends BeaconScreenButton {
        protected final int tier;
        private int effect;
        private TextureAtlasSprite sprite;

        public BeaconPowerButton(int x, int y, int eff, int tier) {
            super(x, y);
            this.tier = tier;
            this.setEffect(eff);
        }

        protected MobEffect getEffect() {
            return HostilityBeaconBlockEntity.BEACON_EFFECTS[this.effect / 2][this.effect % 2];
        }

        protected void setEffect(int eff) {
            this.effect = eff;
            this.sprite = Minecraft.m_91087_().m_91306_().m_118732_(this.getEffect());
            this.m_257544_(Tooltip.m_257563_((Component)this.createEffectDescription(this.getEffect()), null));
        }

        protected MutableComponent createEffectDescription(MobEffect eff) {
            return Component.m_237115_((String)eff.m_19481_());
        }

        public void m_5691_() {
            if (!this.isSelected()) {
                HostilityBeaconScreen.this.primary = this.effect;
                HostilityBeaconScreen.this.updateButtons();
            }
        }

        @Override
        protected void renderIcon(GuiGraphics g) {
            g.m_280159_(this.m_252754_() + 2, this.m_252907_() + 2, 0, 18, 18, this.sprite);
        }

        @Override
        public void updateStatus(int lv) {
            this.f_93623_ = this.tier < lv;
            this.setSelected(this.effect == HostilityBeaconScreen.this.primary);
        }

        protected MutableComponent m_5646_() {
            return this.createEffectDescription(this.getEffect());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class BeaconSpriteScreenButton
    extends BeaconScreenButton {
        private final int iconX;
        private final int iconY;

        protected BeaconSpriteScreenButton(int p_169663_, int p_169664_, int p_169665_, int p_169666_, Component p_169667_) {
            super(p_169663_, p_169664_, p_169667_);
            this.iconX = p_169665_;
            this.iconY = p_169666_;
        }

        @Override
        protected void renderIcon(GuiGraphics p_283624_) {
            p_283624_.m_280218_(BEACON_LOCATION, this.m_252754_() + 2, this.m_252907_() + 2, this.iconX, this.iconY, 18, 18);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class BeaconScreenButton
    extends AbstractButton
    implements BeaconButton {
        private boolean selected;

        protected BeaconScreenButton(int p_98022_, int p_98023_) {
            super(p_98022_, p_98023_, 22, 22, CommonComponents.f_237098_);
        }

        protected BeaconScreenButton(int p_169654_, int p_169655_, Component p_169656_) {
            super(p_169654_, p_169655_, 22, 22, p_169656_);
        }

        public void m_87963_(GuiGraphics p_281837_, int p_281780_, int p_283603_, float p_283562_) {
            int i = 219;
            int j = 0;
            if (!this.f_93623_) {
                j += this.f_93618_ * 2;
            } else if (this.selected) {
                j += this.f_93618_ * 1;
            } else if (this.m_198029_()) {
                j += this.f_93618_ * 3;
            }
            p_281837_.m_280218_(BEACON_LOCATION, this.m_252754_(), this.m_252907_(), j, 219, this.f_93618_, this.f_93619_);
            this.renderIcon(p_281837_);
        }

        protected abstract void renderIcon(GuiGraphics var1);

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean p_98032_) {
            this.selected = p_98032_;
        }

        public void m_168797_(NarrationElementOutput p_259705_) {
            this.m_168802_(p_259705_);
        }
    }
}

