/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.beacon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2hostility.content.item.beacon.HostilityBeaconMenu;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.registrate.LHBlocks;
import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2modularblock.tile_api.NameSetable;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

@SerialClass
public class HostilityBeaconBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
MenuProvider,
NameSetable,
ContainerData {
    private static final int MAX_LEVELS = 3;
    public static final MobEffect[][] BEACON_EFFECTS = new MobEffect[][]{{MobEffects.f_19613_, (MobEffect)LCEffects.ICE.get()}, {(MobEffect)LCEffects.FLAME.get(), (MobEffect)LCEffects.CURSE.get()}, {(MobEffect)LCEffects.CLEANSE.get(), (MobEffect)LCEffects.STONE_CAGE.get()}};
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    private static final Component DEFAULT_NAME = Component.m_237115_((String)"container.beacon");
    List<Section> beamSections = Lists.newArrayList();
    private List<Section> checkingBeamSections = Lists.newArrayList();
    int levels;
    private int lastCheckY;
    @SerialClass.SerialField
    int power = -1;
    @Nullable
    private Component name;
    private LockCode lockKey = LockCode.f_19102_;

    public HostilityBeaconBlockEntity(BlockEntityType<? extends HostilityBeaconBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        BlockPos start;
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (this.lastCheckY < y) {
            start = pos;
            this.checkingBeamSections = Lists.newArrayList();
            this.lastCheckY = y - 1;
        } else {
            start = new BlockPos(x, this.lastCheckY + 1, z);
        }
        Section sec = this.checkingBeamSections.isEmpty() ? null : this.checkingBeamSections.get(this.checkingBeamSections.size() - 1);
        int h = this.f_58857_.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        for (int i = 0; i < 10 && start.m_123342_() <= h; ++i) {
            BlockState state = this.f_58857_.m_8055_(start);
            float[] afloat = state.getBeaconColorMultiplier((LevelReader)this.f_58857_, start, pos);
            if (afloat != null) {
                if (this.checkingBeamSections.size() <= 1) {
                    sec = new Section(afloat);
                    this.checkingBeamSections.add(sec);
                } else if (sec != null) {
                    if (Arrays.equals(afloat, sec.color)) {
                        sec.increaseHeight();
                    } else {
                        sec = new Section(new float[]{(sec.color[0] + afloat[0]) / 2.0f, (sec.color[1] + afloat[1]) / 2.0f, (sec.color[2] + afloat[2]) / 2.0f});
                        this.checkingBeamSections.add(sec);
                    }
                }
            } else {
                if (sec == null || state.m_60739_((BlockGetter)this.f_58857_, start) >= 15 && !state.m_60713_(Blocks.f_50752_)) {
                    this.checkingBeamSections.clear();
                    this.lastCheckY = h;
                    break;
                }
                sec.increaseHeight();
            }
            start = start.m_7494_();
            ++this.lastCheckY;
        }
        int oldLv = this.levels;
        if (this.f_58857_.m_46467_() % 80L == 0L) {
            if (!this.beamSections.isEmpty()) {
                this.levels = HostilityBeaconBlockEntity.updateBase(this.f_58857_, x, y, z);
            }
            if (this.levels > 0 && !this.beamSections.isEmpty()) {
                this.applyEffects(this.f_58857_, pos);
                HostilityBeaconBlockEntity.playSound(this.f_58857_, pos, SoundEvents.f_11737_);
            }
        }
        if (this.lastCheckY >= h) {
            this.lastCheckY = this.f_58857_.m_141937_() - 1;
            boolean flag = oldLv > 0;
            this.beamSections = this.checkingBeamSections;
            if (!this.f_58857_.f_46443_) {
                boolean flag1;
                boolean bl = flag1 = this.levels > 0;
                if (!flag && flag1) {
                    HostilityBeaconBlockEntity.playSound(this.f_58857_, pos, SoundEvents.f_11736_);
                    AABB aabb = new AABB((double)x, (double)y, (double)z, (double)x, (double)(y - 4), (double)z).m_82377_(10.0, 5.0, 10.0);
                    for (ServerPlayer serverplayer : this.f_58857_.m_45976_(ServerPlayer.class, aabb)) {
                        CriteriaTriggers.f_10578_.m_148029_(serverplayer, this.levels);
                    }
                } else if (flag && !flag1) {
                    HostilityBeaconBlockEntity.playSound(this.f_58857_, pos, SoundEvents.f_11738_);
                }
            }
        }
    }

    private static int updateBase(Level level, int x, int y, int z) {
        int y0;
        int ans = 0;
        int iy = 1;
        while (iy <= 3 && (y0 = y - iy) >= level.m_141937_()) {
            boolean valid = true;
            block1: for (int ix = x - iy; ix <= x + iy && valid; ++ix) {
                for (int iz = z - iy; iz <= z + iy; ++iz) {
                    if (level.m_8055_(new BlockPos(ix, y0, iz)).m_204336_(LHTagGen.BEACON_BLOCK)) continue;
                    valid = false;
                    continue block1;
                }
            }
            if (!valid) break;
            ans = iy++;
        }
        return ans;
    }

    public void m_7651_() {
        if (this.f_58857_ != null) {
            HostilityBeaconBlockEntity.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11738_);
        }
        super.m_7651_();
    }

    private void applyEffects(Level level, BlockPos pos) {
        if (!level.f_46443_ && this.power >= 0) {
            MobEffect eff = BEACON_EFFECTS[this.power / 2][this.power % 2];
            double d0 = this.levels * 10 + 10;
            int i = 0;
            int j = (9 + this.levels * 2) * 20;
            AABB aabb = new AABB(pos).m_82400_(d0).m_82363_(0.0, (double)level.m_141928_(), 0.0);
            List list = level.m_45976_(LivingEntity.class, aabb);
            for (LivingEntity e : list) {
                e.m_7292_(new MobEffectInstance(eff, j, i, true, true));
            }
        }
    }

    public static void playSound(Level level, BlockPos pos, SoundEvent sound) {
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public List<Section> getBeamSections() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSections;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.lockKey = LockCode.m_19111_((CompoundTag)tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Levels", this.levels);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        this.lockKey.m_19109_(tag);
    }

    public void setCustomName(@Nullable Component name) {
        this.name = name;
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return this.f_58857_ != null && BaseContainerBlockEntity.m_58629_((Player)player, (LockCode)this.lockKey, (Component)this.m_5446_()) ? new HostilityBeaconMenu((MenuType<HostilityBeaconMenu>)((MenuType)LHBlocks.MT_BEACON.get()), id, inv, this, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_())) : null;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7755_() {
        return this.name != null ? this.name : DEFAULT_NAME;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.lastCheckY = level.m_141937_() - 1;
    }

    public int m_6413_(int index) {
        return switch (index) {
            case 0 -> this.levels;
            case 1 -> this.power;
            default -> 0;
        };
    }

    public void m_8050_(int index, int value) {
        if (this.f_58857_ == null) {
            return;
        }
        switch (index) {
            case 0: {
                this.levels = value;
                break;
            }
            case 1: {
                if (!this.f_58857_.f_46443_ && !this.beamSections.isEmpty()) {
                    HostilityBeaconBlockEntity.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11739_);
                }
                this.power = value;
            }
        }
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int m_6499_() {
        return 2;
    }

    public static class Section {
        final float[] color;
        private int height;

        public Section(float[] color) {
            this.color = color;
            this.height = 1;
        }

        protected void increaseHeight() {
            ++this.height;
        }

        public float[] getColor() {
            return this.color;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

