/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.config;

import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.CollectType;
import dev.xkmc.l2library.serial.config.ConfigCollect;
import dev.xkmc.l2serial.serialization.SerialClass;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.commons.lang3.mutable.MutableBoolean;

@SerialClass
public class WorldDifficultyConfig
extends BaseConfig {
    @ConfigCollect(value=CollectType.MAP_OVERWRITE)
    @SerialClass.SerialField
    public final HashMap<ResourceLocation, DifficultyConfig> levelMap = new HashMap();
    @ConfigCollect(value=CollectType.MAP_OVERWRITE)
    @SerialClass.SerialField
    public final HashMap<ResourceLocation, DifficultyConfig> biomeMap = new HashMap();
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    @SerialClass.SerialField
    public final HashMap<ResourceLocation, ArrayList<EntityConfig.Config>> levelDefaultTraits = new HashMap();
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    @SerialClass.SerialField
    public final HashMap<ResourceLocation, ArrayList<EntityConfig.Config>> structureDefaultTraits = new HashMap();

    public static DifficultyConfig defaultLevel() {
        int base = (Integer)LHConfig.COMMON.defaultLevelBase.get();
        double var = (Double)LHConfig.COMMON.defaultLevelVar.get();
        double scale = (Double)LHConfig.COMMON.defaultLevelScale.get();
        return new DifficultyConfig(0, base, var, scale, 1.0, 1.0, 0.0);
    }

    @Nullable
    public EntityConfig.Config get(ServerLevel level, BlockPos pos, EntityType<?> type) {
        if (!((Boolean)LHConfig.COMMON.enableEntitySpecificDatapack.get()).booleanValue()) {
            return null;
        }
        if (!((Boolean)LHConfig.COMMON.enableStructureSpecificDatapack.get()).booleanValue()) {
            return null;
        }
        if (this.structureDefaultTraits.isEmpty()) {
            return null;
        }
        StructureManager manager = level.m_215010_();
        Map map = manager.m_220522_(pos);
        EntityConfig.Config def = null;
        for (Map.Entry ent : map.entrySet()) {
            Structure structure = (Structure)ent.getKey();
            ResourceLocation key = level.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)structure);
            ArrayList<EntityConfig.Config> list = this.structureDefaultTraits.get(key);
            if (list == null) continue;
            MutableBoolean ans = new MutableBoolean(false);
            manager.m_220480_(structure, (LongSet)ent.getValue(), e -> {
                if (ans.isFalse() && manager.m_220497_(pos, e)) {
                    ans.setTrue();
                }
            });
            if (ans.isFalse()) continue;
            for (EntityConfig.Config e2 : list) {
                if (e2.entities.contains(type)) {
                    return e2;
                }
                if (!e2.entities.isEmpty()) continue;
                def = e2;
            }
        }
        return def;
    }

    @Nullable
    public EntityConfig.Config get(ResourceLocation level, EntityType<?> type) {
        if (!((Boolean)LHConfig.COMMON.enableEntitySpecificDatapack.get()).booleanValue()) {
            return null;
        }
        ArrayList<EntityConfig.Config> list = this.levelDefaultTraits.get(level);
        if (list == null) {
            return null;
        }
        EntityConfig.Config def = null;
        for (EntityConfig.Config e : list) {
            if (e.entities.contains(type)) {
                return e;
            }
            if (!e.entities.isEmpty()) continue;
            def = e;
        }
        return def;
    }

    public WorldDifficultyConfig putDim(ResourceKey<Level> key, int min, int base, double var, double scale) {
        this.levelMap.put(key.m_135782_(), new DifficultyConfig(min, base, var, scale, 1.0, 1.0, 0.0));
        return this;
    }

    @SafeVarargs
    public final WorldDifficultyConfig putBiome(int min, int base, double var, double scale, ResourceKey<Biome> ... keys) {
        for (ResourceKey<Biome> key : keys) {
            this.biomeMap.put(key.m_135782_(), new DifficultyConfig(min, base, var, scale, 1.0, 1.0, 0.0));
        }
        return this;
    }

    public WorldDifficultyConfig putLevelDef(ResourceKey<Level> id, EntityConfig.Config config) {
        this.levelDefaultTraits.computeIfAbsent(id.m_135782_(), l -> new ArrayList()).add(config);
        return this;
    }

    public WorldDifficultyConfig putStructureDef(ResourceKey<Structure> id, EntityConfig.Config config) {
        this.structureDefaultTraits.computeIfAbsent(id.m_135782_(), l -> new ArrayList()).add(config);
        return this;
    }

    public record DifficultyConfig(int min, int base, double variation, double scale, double apply_chance, double trait_chance, double suppression) {
    }
}

