/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.config;

import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2library.serial.conditions.BooleanValueCondition;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.CollectType;
import dev.xkmc.l2library.serial.config.ConfigCollect;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class WeaponConfig
extends BaseConfig {
    @SerialClass.SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<ItemConfig> melee_weapons = new ArrayList();
    @SerialClass.SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<ItemConfig> armors = new ArrayList();
    @SerialClass.SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<ItemConfig> ranged_weapons = new ArrayList();
    @SerialClass.SerialField
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    public final LinkedHashMap<LinkedHashSet<EntityType<?>>, ArrayList<ItemConfig>> special_weapons = new LinkedHashMap();
    @SerialClass.SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<EnchConfig> weapon_enchantments = new ArrayList();
    @SerialClass.SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<EnchConfig> armor_enchantments = new ArrayList();

    public static ItemStack getRandomMeleeWeapon(int level, RandomSource r, @Nullable ServerPlayer player) {
        WeaponConfig config = (WeaponConfig)L2Hostility.WEAPON.getMerged();
        return WeaponConfig.getRandomWeapon(config.melee_weapons, level, r, player);
    }

    public static ItemStack getRandomArmor(EquipmentSlot slot, int level, RandomSource r, @Nullable ServerPlayer player) {
        WeaponConfig config = (WeaponConfig)L2Hostility.WEAPON.getMerged();
        return WeaponConfig.getRandomArmors(slot, config.armors, level, r, player);
    }

    public static ItemStack getRandomRangedWeapon(int level, RandomSource r, @Nullable ServerPlayer player) {
        WeaponConfig config = (WeaponConfig)L2Hostility.WEAPON.getMerged();
        return WeaponConfig.getRandomWeapon(config.ranged_weapons, level, r, player);
    }

    public static ItemStack getRandomWeapon(ArrayList<ItemConfig> entries, int level, RandomSource r, @Nullable ServerPlayer player) {
        int total = 0;
        ArrayList<ItemConfig> list = new ArrayList<ItemConfig>();
        for (ItemConfig e : entries) {
            if (!e.test(level, player)) continue;
            list.add(e);
            total += e.weight();
        }
        if (total == 0) {
            return ItemStack.f_41583_;
        }
        int val = r.m_188503_(total);
        for (ItemConfig e : list) {
            if ((val -= e.weight()) > 0) continue;
            return e.stack.get(r.m_188503_(e.stack.size())).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getRandomArmors(EquipmentSlot slot, ArrayList<ItemConfig> entries, int level, RandomSource r, @Nullable ServerPlayer player) {
        int total = 0;
        ArrayList<ItemConfig> list = new ArrayList<ItemConfig>();
        for (ItemConfig e : entries) {
            if (!e.test(level, player)) continue;
            ArrayList<ItemStack> sub = new ArrayList<ItemStack>();
            for (ItemStack item : e.stack) {
                ArmorItem eq;
                Item item2;
                if (!item.m_41619_() && (!((item2 = item.m_41720_()) instanceof ArmorItem) || (eq = (ArmorItem)item2).m_40402_() != slot) && item.getEquipmentSlot() != slot) continue;
                sub.add(item);
            }
            if (sub.isEmpty()) continue;
            list.add(new ItemConfig(sub, e.level, e.weight));
            total += e.weight();
        }
        if (total == 0) {
            return ItemStack.f_41583_;
        }
        int val = r.m_188503_(total);
        for (ItemConfig e : list) {
            if ((val -= e.weight()) > 0) continue;
            return e.stack.get(r.m_188503_(e.stack.size())).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public WeaponConfig putMeleeWeapon(int level, int weight, Item ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item e : items) {
            list.add(e.m_7968_());
        }
        this.melee_weapons.add(new ItemConfig(list, level, weight));
        return this;
    }

    public WeaponConfig putArmor(int level, int weight, Item ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item e : items) {
            list.add(e.m_7968_());
        }
        this.armors.add(new ItemConfig(list, level, weight));
        return this;
    }

    public WeaponConfig putRangedWeapon(int level, int weight, Item ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item e : items) {
            list.add(e.m_7968_());
        }
        this.ranged_weapons.add(new ItemConfig(list, level, weight));
        return this;
    }

    public WeaponConfig putWeaponEnch(int level, float chance, Enchantment ... items) {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>(Arrays.asList(items));
        this.weapon_enchantments.add(new EnchConfig(list, level, chance));
        return this;
    }

    public WeaponConfig putArmorEnch(int level, float chance, Enchantment ... items) {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>(Arrays.asList(items));
        this.armor_enchantments.add(new EnchConfig(list, level, chance));
        return this;
    }

    public record ItemConfig(ArrayList<ItemStack> stack, int level, int weight, @Nullable ItemCondition condition) {
        public static final ItemConfig EMPTY = new ItemConfig(new ArrayList<ItemStack>(List.of(ItemStack.f_41583_)), 0, 1000);

        public ItemConfig(ArrayList<ItemStack> stack, int level, int weight) {
            this(stack, level, weight, null);
        }

        public boolean test(int lv, @Nullable ServerPlayer player) {
            if (lv < this.level()) {
                return false;
            }
            return this.condition == null || this.condition.test(player);
        }
    }

    public record EnchConfig(ArrayList<Enchantment> enchantments, int level, float chance) {
    }

    public record ItemCondition(ArrayList<ResourceLocation> advancements, @Nullable BooleanValueCondition config) {
        public boolean test(@Nullable ServerPlayer sp) {
            if (this.config != null && !this.config.test(null)) {
                return false;
            }
            if (!this.advancements.isEmpty()) {
                if (sp == null) {
                    return false;
                }
                MinecraftServer server = sp.m_9236_().m_7654_();
                if (server == null) {
                    return false;
                }
                ServerAdvancementManager manager = server.m_129889_();
                PlayerAdvancements spAdv = sp.m_8960_();
                for (ResourceLocation e : this.advancements) {
                    Advancement adv = manager.m_136041_(e);
                    if (adv == null) {
                        return false;
                    }
                    if (spAdv.m_135996_(adv).m_8193_()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

