/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.config;

import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@SerialClass
public class TraitConfig
extends BaseConfig {
    public static final TraitConfig DEFAULT = new TraitConfig(new ResourceLocation("l2hostility", "default"), 10, 100, 1, 10);
    @SerialClass.SerialField
    public int min_level;
    @SerialClass.SerialField
    public int cost;
    @SerialClass.SerialField
    public int max_rank;
    @SerialClass.SerialField
    public int weight;

    @Deprecated
    public TraitConfig() {
    }

    public TraitConfig(ResourceLocation rl, int cost, int weight, int maxRank, int minLevel) {
        this.id = rl;
        this.cost = cost;
        this.weight = weight;
        this.max_rank = maxRank;
        this.min_level = minLevel;
        this.addBlacklist(e -> {});
        this.addWhitelist(e -> {});
    }

    public TagKey<EntityType<?>> getBlacklistTag() {
        assert (this.id != null);
        ResourceLocation tag = new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_blacklist");
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tag);
    }

    public TagKey<EntityType<?>> getWhitelistTag() {
        assert (this.id != null);
        ResourceLocation tag = new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_whitelist");
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tag);
    }

    public TraitConfig addWhitelist(Consumer<IntrinsicHolderTagsProvider.IntrinsicTagAppender<EntityType<?>>> pvd) {
        TagKey<EntityType<?>> tag = this.getWhitelistTag();
        LHTagGen.ENTITY_TAG_BUILDER.put(tag.f_203868_(), e -> pvd.accept(e.addTag(tag)));
        return this;
    }

    public TraitConfig addBlacklist(Consumer<IntrinsicHolderTagsProvider.IntrinsicTagAppender<EntityType<?>>> pvd) {
        TagKey<EntityType<?>> tag = this.getBlacklistTag();
        LHTagGen.ENTITY_TAG_BUILDER.put(tag.f_203868_(), e -> pvd.accept(e.addTag(tag)));
        return this;
    }

    public boolean allows(EntityType<?> type) {
        TagKey<EntityType<?>> blacklist = this.getBlacklistTag();
        TagKey<EntityType<?>> whitelist = this.getWhitelistTag();
        ITagManager manager = ForgeRegistries.ENTITY_TYPES.tags();
        assert (manager != null);
        boolean def = true;
        if (!manager.getTag(blacklist).isEmpty() && type.m_204039_(blacklist)) {
            return false;
        }
        if (!manager.getTag(whitelist).isEmpty()) {
            if (type.m_204039_(whitelist)) {
                return true;
            }
            def = false;
        }
        return def;
    }
}

