/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.SectionDifficulty;
import dev.xkmc.l2hostility.content.command.HostilityCommands;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class LHRegionCommands
extends HostilityCommands {
    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHRegionCommands.literal("region").then(LHRegionCommands.section())).then(LHRegionCommands.area());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> section() {
        return (LiteralArgumentBuilder)LHRegionCommands.literal("section").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)LHRegionCommands.argument("pos", BlockPosArgument.m_118239_()).then(((LiteralArgumentBuilder)LHRegionCommands.literal("set_base").requires(e -> e.m_6761_(2))).then(LHRegionCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHRegionCommands.sectionLevel((section, level, pos, lv) -> section.getLevelEditor(level, pos).setBase(lv)))))).then(((LiteralArgumentBuilder)LHRegionCommands.literal("add_base").requires(e -> e.m_6761_(2))).then(LHRegionCommands.argument("level", IntegerArgumentType.integer()).executes(LHRegionCommands.sectionLevel((section, level, pos, lv) -> section.getLevelEditor(level, pos).addBase(lv)))))).then(((LiteralArgumentBuilder)LHRegionCommands.literal("set_clear").requires(e -> e.m_6761_(2))).executes(LHRegionCommands.sectionRun((section, level, pos) -> section.setClear(ChunkDifficulty.at(level, pos).get(), pos))))).then(((LiteralArgumentBuilder)LHRegionCommands.literal("set_unclear").requires(e -> e.m_6761_(2))).executes(LHRegionCommands.sectionRun((section, level, pos) -> section.setUnclear(ChunkDifficulty.at(level, pos).get(), pos))))).then(LHRegionCommands.literal("get_base").executes(LHRegionCommands.sectionGet((section, level, pos) -> LangData.COMMAND_REGION_GET_BASE.get(section.getLevelEditor(level, pos).getBase()))))).then(LHRegionCommands.literal("get_total").executes(LHRegionCommands.sectionGet((section, level, pos) -> LangData.COMMAND_REGION_GET_TOTAL.get(section.getLevelEditor(level, pos).getTotal()))))).then(LHRegionCommands.literal("get_scale").executes(LHRegionCommands.sectionGet((section, level, pos) -> LangData.COMMAND_REGION_GET_SCALE.get(section.getScale(level, pos)))))).then(LHRegionCommands.literal("is_clear").executes(LHRegionCommands.sectionGet((section, level, pos) -> section.isCleared() ? LangData.COMMAND_REGION_CLEAR.get(new Object[0]) : LangData.COMMAND_REGION_NOT_CLEAR.get(new Object[0])))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> area() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHRegionCommands.literal("area").requires(e -> e.m_6761_(2))).then(LHRegionCommands.argument("from", BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)LHRegionCommands.argument("to", BlockPosArgument.m_118239_()).then(LHRegionCommands.literal("set_base").then(LHRegionCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHRegionCommands.areaLevel((section, level, pos, lv) -> section.getLevelEditor(level, pos).setBase(lv)))))).then(LHRegionCommands.literal("add_base").then(LHRegionCommands.argument("level", IntegerArgumentType.integer()).executes(LHRegionCommands.areaLevel((section, level, pos, lv) -> section.getLevelEditor(level, pos).addBase(lv)))))).then(LHRegionCommands.literal("set_clear").executes(LHRegionCommands.areaRun((section, level, pos) -> section.setClear(ChunkDifficulty.at(level, pos).get(), pos))))).then(LHRegionCommands.literal("set_unclear").executes(LHRegionCommands.areaRun((section, level, pos) -> section.setUnclear(ChunkDifficulty.at(level, pos).get(), pos))))));
    }

    private static Command<CommandSourceStack> sectionLevel(SectionLevelCommand cmd) {
        return ctx -> {
            int level = (Integer)ctx.getArgument("level", Integer.class);
            BlockPos sel = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos");
            Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).m_81372_(), sel);
            if (e.isEmpty()) {
                throw BlockPosArgument.f_118234_.create();
            }
            if (!((Boolean)LHConfig.COMMON.allowSectionDifficulty.get()).booleanValue()) {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)LangData.COMMAND_REGION_LOCAL_OFF.get(new Object[0]).m_130940_(ChatFormatting.RED));
                return 1;
            }
            cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).m_81372_(), sel, level);
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)LangData.COMMAND_REGION_SUCCEED.get(new Object[0]));
            return 0;
        };
    }

    private static Command<CommandSourceStack> sectionRun(SectionCommand cmd) {
        return ctx -> {
            BlockPos sel = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos");
            Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).m_81372_(), sel);
            if (e.isEmpty()) {
                throw BlockPosArgument.f_118234_.create();
            }
            cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).m_81372_(), sel);
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)LangData.COMMAND_REGION_SUCCEED.get(new Object[0]));
            return 0;
        };
    }

    private static Command<CommandSourceStack> sectionGet(SectionGet cmd) {
        return ctx -> {
            BlockPos sel = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos");
            Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).m_81372_(), sel);
            if (e.isEmpty()) {
                throw BlockPosArgument.f_118234_.create();
            }
            ((CommandSourceStack)ctx.getSource()).m_243053_(cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).m_81372_(), sel));
            return 0;
        };
    }

    private static Command<CommandSourceStack> areaLevel(SectionLevelCommand cmd) {
        return ctx -> {
            int level = (Integer)ctx.getArgument("level", Integer.class);
            BlockPos from = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"from");
            BlockPos to = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"to");
            if (!((Boolean)LHConfig.COMMON.allowSectionDifficulty.get()).booleanValue()) {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)LangData.COMMAND_REGION_LOCAL_OFF.get(new Object[0]).m_130940_(ChatFormatting.RED));
                return 1;
            }
            int count = LHRegionCommands.iterate(from, to, sel -> {
                Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).m_81372_(), sel);
                if (e.isEmpty()) {
                    return false;
                }
                return cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).m_81372_(), (BlockPos)sel, level);
            });
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)LangData.COMMAND_REGION_COUNT.get(count));
            return 0;
        };
    }

    private static Command<CommandSourceStack> areaRun(SectionCommand cmd) {
        return ctx -> {
            BlockPos from = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"from");
            BlockPos to = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"to");
            int count = LHRegionCommands.iterate(from, to, sel -> {
                Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).m_81372_(), sel);
                if (e.isEmpty()) {
                    return false;
                }
                return cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).m_81372_(), (BlockPos)sel);
            });
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)LangData.COMMAND_REGION_COUNT.get(count));
            return 0;
        };
    }

    private static int iterate(BlockPos from, BlockPos to, Predicate<BlockPos> pred) {
        AABB aabb = new AABB(from, to);
        int x0 = (int)aabb.f_82288_ & 0xFFFFFFF1;
        int y0 = (int)aabb.f_82289_ & 0xFFFFFFF1;
        int z0 = (int)aabb.f_82290_ & 0xFFFFFFF1;
        int x1 = (int)aabb.f_82291_ & 0xFFFFFFF1;
        int y1 = (int)aabb.f_82292_ & 0xFFFFFFF1;
        int z1 = (int)aabb.f_82293_ & 0xFFFFFFF1;
        int count = 0;
        for (int x = x0; x <= x1; x += 16) {
            for (int y = y0; y <= y1; y += 16) {
                for (int z = z0; z <= z1; z += 16) {
                    if (!pred.test(new BlockPos(x, y, z))) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private static interface SectionLevelCommand {
        public boolean run(SectionDifficulty var1, Level var2, BlockPos var3, int var4);
    }

    private static interface SectionCommand {
        public boolean run(SectionDifficulty var1, Level var2, BlockPos var3);
    }

    private static interface SectionGet {
        public Component run(SectionDifficulty var1, Level var2, BlockPos var3);
    }
}

