/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.command.HostilityCommands;
import dev.xkmc.l2hostility.content.logic.TraitManager;
import dev.xkmc.l2hostility.init.data.LangData;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LHPlayerCommands
extends HostilityCommands {
    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)LHPlayerCommands.literal("player").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)LHPlayerCommands.argument("player", EntityArgument.m_91470_()).then(LHPlayerCommands.difficulty())).then(LHPlayerCommands.trait())).then(LHPlayerCommands.dim()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> difficulty() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("difficulty").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("base").then(((LiteralArgumentBuilder)LHPlayerCommands.literal("set").requires(e -> e.m_6761_(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHPlayerCommands.playerLevel((player, level) -> player.getLevelEditor().setBase(level)))))).then(((LiteralArgumentBuilder)LHPlayerCommands.literal("add").requires(e -> e.m_6761_(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer()).executes(LHPlayerCommands.playerLevel((player, level) -> player.getLevelEditor().addBase(level)))))).then(LHPlayerCommands.literal("get").executes(LHPlayerCommands.playerGet(player -> LangData.COMMAND_PLAYER_GET_BASE.get(player.player.m_5446_(), player.getLevelEditor().getBase())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("total").then(((LiteralArgumentBuilder)LHPlayerCommands.literal("set").requires(e -> e.m_6761_(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHPlayerCommands.playerLevel((player, level) -> player.getLevelEditor().setTotal(level)))))).then(((LiteralArgumentBuilder)LHPlayerCommands.literal("add").requires(e -> e.m_6761_(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer()).executes(LHPlayerCommands.playerLevel((player, level) -> player.getLevelEditor().addTotal(level)))))).then(LHPlayerCommands.literal("get").executes(LHPlayerCommands.playerGet(player -> LangData.COMMAND_PLAYER_GET_TOTAL.get(player.player.m_5446_(), player.getLevelEditor().getTotal())))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> trait() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("traitCap").then(((LiteralArgumentBuilder)LHPlayerCommands.literal("set").requires(e -> e.m_6761_(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer((int)0, (int)TraitManager.getMaxLevel())).executes(LHPlayerCommands.playerLevel((player, level) -> {
            player.maxRankKilled = level;
            return true;
        }))))).then(LHPlayerCommands.literal("get").executes(LHPlayerCommands.playerGet(player -> LangData.COMMAND_PLAYER_GET_TRAIT_CAP.get(player.player.m_5446_(), player.maxRankKilled))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> dim() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("dimensions").then(((LiteralArgumentBuilder)LHPlayerCommands.literal("clear").requires(e -> e.m_6761_(2))).executes(LHPlayerCommands.playerRun(player -> {
            boolean ans = !player.dimensions.isEmpty();
            player.dimensions.clear();
            return ans;
        })))).then(LHPlayerCommands.literal("get").executes(LHPlayerCommands.playerGet(player -> LangData.COMMAND_PLAYER_GET_DIM.get(player.player.m_5446_(), player.dimensions.size()))));
    }

    private static Command<CommandSourceStack> playerRun(PlayerCommand cmd) {
        return ctx -> {
            EntitySelector sel = (EntitySelector)ctx.getArgument("player", EntitySelector.class);
            List list = sel.m_121166_((CommandSourceStack)ctx.getSource());
            int count = LHPlayerCommands.iterate(list, cmd::run);
            LHPlayerCommands.printCompletion((CommandSourceStack)ctx.getSource(), count);
            return 0;
        };
    }

    private static Command<CommandSourceStack> playerGet(PlayerGet cmd) {
        return ctx -> {
            EntitySelector sel = (EntitySelector)ctx.getArgument("player", EntitySelector.class);
            List list = sel.m_121166_((CommandSourceStack)ctx.getSource());
            for (ServerPlayer e : list) {
                ((CommandSourceStack)ctx.getSource()).m_243053_(cmd.run((PlayerDifficulty)PlayerDifficulty.HOLDER.get((Player)e)));
            }
            return 0;
        };
    }

    private static Command<CommandSourceStack> playerLevel(PlayerLevelCommand cmd) {
        return ctx -> {
            int level = (Integer)ctx.getArgument("level", Integer.class);
            EntitySelector sel = (EntitySelector)ctx.getArgument("player", EntitySelector.class);
            List list = sel.m_121166_((CommandSourceStack)ctx.getSource());
            int count = LHPlayerCommands.iterate(list, cap -> cmd.run((PlayerDifficulty)((Object)((Object)cap)), level));
            LHPlayerCommands.printCompletion((CommandSourceStack)ctx.getSource(), count);
            return 0;
        };
    }

    private static int iterate(List<ServerPlayer> list, Predicate<PlayerDifficulty> task) {
        int count = 0;
        for (ServerPlayer e : list) {
            PlayerDifficulty cap = (PlayerDifficulty)PlayerDifficulty.HOLDER.get((Player)e);
            if (!task.test(cap)) continue;
            cap.sync();
            ++count;
        }
        return count;
    }

    private static void printCompletion(CommandSourceStack ctx, int count) {
        if (count > 0) {
            ctx.m_243053_((Component)LangData.COMMAND_PLAYER_SUCCEED.get(count));
        } else {
            ctx.m_243053_((Component)LangData.COMMAND_PLAYER_FAIL.get(new Object[0]).m_130940_(ChatFormatting.RED));
        }
    }

    private static interface PlayerLevelCommand {
        public boolean run(PlayerDifficulty var1, int var2);
    }

    private static interface PlayerGet {
        public Component run(PlayerDifficulty var1);
    }

    private static interface PlayerCommand {
        public boolean run(PlayerDifficulty var1);
    }
}

