/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.capability.mob;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.RegionalDifficultyModifier;
import dev.xkmc.l2hostility.content.capability.mob.CapStorageData;
import dev.xkmc.l2hostility.content.capability.mob.MasterData;
import dev.xkmc.l2hostility.content.capability.mob.MinionData;
import dev.xkmc.l2hostility.content.capability.mob.MobCapSyncToClient;
import dev.xkmc.l2hostility.content.capability.mob.PerformanceConstants;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.config.WorldDifficultyConfig;
import dev.xkmc.l2hostility.content.item.spawner.TraitSpawnerBlockEntity;
import dev.xkmc.l2hostility.content.logic.InheritContext;
import dev.xkmc.l2hostility.content.logic.ItemPopulator;
import dev.xkmc.l2hostility.content.logic.MobDifficultyCollector;
import dev.xkmc.l2hostility.content.logic.PlayerFinder;
import dev.xkmc.l2hostility.content.logic.TraitManager;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.events.ClientEvents;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.advancements.HostilityTriggers;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import dev.xkmc.l2library.capability.entity.GeneralCapabilityHolder;
import dev.xkmc.l2library.capability.entity.GeneralCapabilityTemplate;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@SerialClass
public class MobTraitCap
extends GeneralCapabilityTemplate<LivingEntity, MobTraitCap> {
    public static final Capability<MobTraitCap> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<MobTraitCap>(){});
    public static final GeneralCapabilityHolder<LivingEntity, MobTraitCap> HOLDER = new GeneralCapabilityHolder(new ResourceLocation("l2hostility", "traits"), CAPABILITY, MobTraitCap.class, MobTraitCap::new, LivingEntity.class, e -> e.m_6095_().m_204039_(LHTagGen.WHITELIST) || e instanceof Enemy && !e.m_6095_().m_204039_(LHTagGen.BLACKLIST));
    @SerialClass.SerialField(toClient=true)
    public final LinkedHashMap<MobTrait, Integer> traits = new LinkedHashMap();
    @SerialClass.SerialField(toClient=true)
    private Stage stage = Stage.PRE_INIT;
    @SerialClass.SerialField(toClient=true)
    public int lv;
    @SerialClass.SerialField
    private final HashMap<ResourceLocation, CapStorageData> data = new HashMap();
    @SerialClass.SerialField(toClient=true)
    public boolean summoned = false;
    @SerialClass.SerialField(toClient=true)
    public boolean minion = false;
    @SerialClass.SerialField(toClient=true)
    public boolean noDrop = false;
    @SerialClass.SerialField(toClient=true)
    public boolean fullDrop = false;
    @SerialClass.SerialField
    public double dropRate = 1.0;
    @Nullable
    @SerialClass.SerialField
    public BlockPos pos = null;
    @Nullable
    @SerialClass.SerialField(toClient=true)
    public MinionData asMinion = null;
    @Nullable
    @SerialClass.SerialField(toClient=true)
    public MasterData asMaster = null;
    @Nullable
    private TraitSpawnerBlockEntity summoner = null;
    private boolean inherited = false;
    private boolean ticking = false;
    private EntityConfig.Config configCache = null;
    private final ArrayList<Pair<MobTrait, Integer>> pending = new ArrayList();

    public void syncToClient(LivingEntity entity) {
        L2Hostility.HANDLER.toTrackingPlayers((SimplePacketBase)new MobCapSyncToClient(entity, this), (Entity)entity);
    }

    public void syncToPlayer(LivingEntity entity, ServerPlayer player) {
        L2Hostility.HANDLER.toClientPlayer((SimplePacketBase)new MobCapSyncToClient(entity, this), player);
    }

    public static void register() {
    }

    public void deinit() {
        this.traits.clear();
        this.lv = 0;
        this.stage = Stage.PRE_INIT;
    }

    public boolean reinit(LivingEntity mob, int level, boolean max) {
        this.deinit();
        this.init(mob.m_9236_(), mob, (pos, ins) -> {
            ins.base = level;
            if (max) {
                ins.setFullChance();
            }
        });
        return true;
    }

    @Nullable
    public EntityConfig.Config getConfigCache(LivingEntity le) {
        Level level;
        if (this.configCache == null) {
            this.configCache = ((EntityConfig)L2Hostility.ENTITY.getMerged()).get(le.m_6095_());
        }
        if (this.configCache == null && (level = le.m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.configCache = ((WorldDifficultyConfig)L2Hostility.DIFFICULTY.getMerged()).get(sl, le.m_20183_(), le.m_6095_());
        }
        if (this.configCache == null) {
            this.configCache = ((WorldDifficultyConfig)L2Hostility.DIFFICULTY.getMerged()).get(le.m_9236_().m_46472_().m_135782_(), le.m_6095_());
        }
        return this.configCache;
    }

    public void setConfigCache(EntityConfig.Config config) {
        this.configCache = config;
    }

    public void init(Level level, LivingEntity le, RegionalDifficultyModifier difficulty) {
        Mob mob;
        boolean skip = (Boolean)LHConfig.COMMON.allowNoAI.get() == false && le instanceof Mob && (mob = (Mob)le).m_21525_();
        MobDifficultyCollector instance = new MobDifficultyCollector();
        EntityConfig.Config diff = this.getConfigCache(le);
        if (diff != null) {
            instance.acceptConfig(diff.difficulty());
        }
        difficulty.modifyInstance(le.m_20183_(), instance);
        Player player = PlayerFinder.getNearestPlayer(level, le);
        if (player != null && PlayerDifficulty.HOLDER.isProper((ICapabilityProvider)player)) {
            PlayerDifficulty playerDiff = (PlayerDifficulty)PlayerDifficulty.HOLDER.get(player);
            playerDiff.apply(instance);
            if (!((Boolean)LHConfig.COMMON.allowPlayerAllies.get()).booleanValue() && le.m_7307_((Entity)player)) {
                skip = true;
            }
        }
        this.lv = skip ? 0 : TraitManager.fill(this, le, this.traits, instance);
        this.fullDrop = instance.isFullDrop();
        this.stage = Stage.INIT;
        this.syncToClient(le);
    }

    public void copyFrom(LivingEntity par, LivingEntity child, MobTraitCap parent) {
        InheritContext ctx = new InheritContext(par, parent, child, this, !parent.inherited);
        parent.inherited = true;
        this.lv = parent.lv;
        this.summoned = parent.summoned;
        this.minion = parent.minion;
        this.noDrop = parent.noDrop;
        this.dropRate = parent.dropRate * (Double)LHConfig.COMMON.splitDropRateFactor.get();
        for (Map.Entry<MobTrait, Integer> ent : parent.traits.entrySet()) {
            int rank = ent.getKey().inherited(this, ent.getValue(), ctx);
            if (rank <= 0) continue;
            this.traits.put(ent.getKey(), rank);
        }
        TraitManager.fill(this, child, this.traits, MobDifficultyCollector.noTrait(this.lv));
        this.stage = Stage.INIT;
    }

    public int getEnchantBonus() {
        return (int)((double)this.lv * (Double)LHConfig.COMMON.enchantmentFactor.get());
    }

    public int getLevel() {
        return this.lv;
    }

    public void setLevel(LivingEntity le, int level) {
        this.lv = this.clampLevel(le, level);
        TraitManager.scale(this, le, this.lv);
    }

    public int clampLevel(LivingEntity le, int lv) {
        int cap = (Integer)LHConfig.COMMON.maxMobLevel.get();
        EntityConfig.Config config = this.getConfigCache(le);
        if (config != null && config.maxLevel > 0) {
            cap = Math.min(config.maxLevel, cap);
        }
        return Math.min(cap, lv);
    }

    public boolean isInitialized() {
        return this.stage != Stage.PRE_INIT;
    }

    public int getTraitLevel(MobTrait trait) {
        return this.traits.getOrDefault((Object)trait, 0);
    }

    public boolean hasTrait(MobTrait trait) {
        return this.getTraitLevel(trait) > 0;
    }

    public void traitEvent(BiConsumer<MobTrait, Integer> cons) {
        this.traits.forEach(cons);
    }

    public void setTrait(MobTrait trait, int lv) {
        this.pending.add((Pair<MobTrait, Integer>)Pair.of((Object)((Object)trait), (Object)lv));
    }

    public void removeTrait(MobTrait trait) {
        if (!this.traits.containsKey((Object)trait)) {
            return;
        }
        if (this.ticking) {
            this.setTrait(trait, 0);
        } else {
            this.traits.remove((Object)trait);
        }
    }

    private boolean clearPending(LivingEntity mob) {
        if (this.pending.isEmpty()) {
            return false;
        }
        while (!this.pending.isEmpty()) {
            ArrayList<Pair<MobTrait, Integer>> temp = new ArrayList<Pair<MobTrait, Integer>>(this.pending);
            for (Pair<MobTrait, Integer> pair : this.pending) {
                this.traits.put((MobTrait)((Object)pair.getFirst()), (Integer)pair.getSecond());
            }
            this.pending.clear();
            for (Pair<MobTrait, Integer> pair : temp) {
                ((MobTrait)((Object)pair.getFirst())).initialize(mob, (Integer)pair.getSecond());
                ((MobTrait)((Object)pair.getFirst())).postInit(mob, (Integer)pair.getSecond());
            }
            for (Pair<MobTrait, Integer> pair : temp) {
                if ((Integer)pair.getSecond() != 0) continue;
                this.traits.remove(pair.getFirst());
            }
        }
        return true;
    }

    public void tick(LivingEntity mob) {
        boolean sync = false;
        this.ticking = true;
        if (!mob.m_9236_().m_5776_()) {
            OwnableEntity own;
            if (!this.isInitialized()) {
                Optional<ChunkDifficulty> opt = ChunkDifficulty.at(mob.m_9236_(), mob.m_20183_());
                opt.ifPresent(chunkDifficulty -> this.init(mob.m_9236_(), mob, (RegionalDifficultyModifier)chunkDifficulty));
            }
            if (this.stage == Stage.INIT) {
                this.stage = Stage.POST_INIT;
                ItemPopulator.postFill(this, mob);
                this.traits.forEach((k, v) -> k.postInit(mob, (int)v));
                this.clearPending(mob);
                mob.m_21153_(mob.m_21233_());
                sync = true;
            }
            if (!this.traits.isEmpty() && !((Boolean)LHConfig.COMMON.allowTraitOnOwnable.get()).booleanValue() && mob instanceof OwnableEntity && (own = (OwnableEntity)mob).m_269323_() instanceof Player) {
                this.traits.clear();
                sync = true;
            }
        }
        if (this.isInitialized()) {
            if (!this.traits.isEmpty()) {
                if (mob.f_19797_ % PerformanceConstants.removeTraitInterval() == 0) {
                    sync |= this.traits.keySet().removeIf(Objects::isNull);
                    sync |= this.traits.keySet().removeIf(MobTrait::isBanned);
                }
                this.traits.forEach((k, v) -> k.tick(mob, (int)v));
            }
            sync |= this.clearPending(mob);
        }
        if (!mob.m_9236_().m_5776_() && this.pos != null) {
            BlockEntity blockEntity;
            if (this.summoner == null && (blockEntity = mob.m_9236_().m_7702_(this.pos)) instanceof TraitSpawnerBlockEntity) {
                TraitSpawnerBlockEntity be;
                this.summoner = be = (TraitSpawnerBlockEntity)blockEntity;
            }
            if (this.summoner == null || this.summoner.m_58901_()) {
                mob.m_146870_();
            }
        }
        if (this.asMinion != null) {
            sync |= this.asMinion.tick(mob);
        }
        if (this.hasTrait((MobTrait)((Object)LHTraits.MASTER.get()))) {
            if (!mob.m_9236_().m_5776_() && this.asMaster == null) {
                this.asMaster = new MasterData();
                sync = true;
            }
            if (mob instanceof Mob) {
                Mob master = (Mob)mob;
                if (this.asMaster != null) {
                    sync |= this.asMaster.tick(this, master);
                }
            }
            if (mob.m_9236_().m_5776_()) {
                if (mob instanceof Mob) {
                    Mob m = (Mob)mob;
                    ClientEvents.MASTERS.add(m);
                }
                mob.m_20049_("HostilityGlowing");
            }
        }
        if (this.summoned && mob.m_9236_().m_5776_()) {
            mob.m_20049_("HostilityGlowing");
        }
        if (!mob.m_9236_().m_5776_() && sync && !mob.m_213877_()) {
            this.syncToClient(mob);
        }
        this.ticking = false;
    }

    public boolean shouldDiscard(LivingEntity mob) {
        EntityConfig.Config config = this.getConfigCache(mob);
        if (config == null || config.minSpawnLevel <= 0) {
            return false;
        }
        return this.lv < config.minSpawnLevel;
    }

    public void onKilled(LivingEntity mob, @Nullable Player player) {
        if (this.summoner != null && !this.summoner.m_58901_()) {
            this.summoner.data.onDeath(mob);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            HostilityTriggers.TRAIT_LEVEL.trigger(sp, this);
            HostilityTriggers.TRAIT_COUNT.trigger(sp, this);
            HostilityTriggers.KILL_TRAITS.trigger(sp, this);
            HostilityTriggers.TRAIT_FLAME.trigger(sp, mob, this);
            HostilityTriggers.TRAIT_EFFECT.trigger(sp, mob, this);
        }
    }

    public boolean isSummoned() {
        return this.summoned || this.minion;
    }

    public boolean isMasterProtected() {
        if (this.asMaster != null) {
            for (MasterData.Minion e : this.asMaster.data) {
                if (e.minion == null || !HOLDER.isProper((ICapabilityProvider)e.minion)) continue;
                MobTraitCap scap = (MobTraitCap)HOLDER.get((ICapabilityProvider)e.minion);
                if (scap.asMinion == null || !scap.asMinion.protectMaster) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public <T extends CapStorageData> T getData(ResourceLocation id) {
        return (T)((CapStorageData)Wrappers.cast((Object)this.data.get(id)));
    }

    public <T extends CapStorageData> T getOrCreateData(ResourceLocation id, Supplier<T> sup) {
        return (T)((CapStorageData)Wrappers.cast((Object)this.data.computeIfAbsent(id, e -> (CapStorageData)sup.get())));
    }

    public List<Component> getTitle(boolean showLevel, boolean showTrait) {
        ArrayList<Component> ans = new ArrayList<Component>();
        if (showLevel && this.lv > 0) {
            ans.add((Component)LangData.LV.get(this.lv).m_130948_(Style.f_131099_.m_178520_((this.fullDrop ? (Integer)LHConfig.CLIENT.overHeadLevelColorAbyss.get() : (Integer)LHConfig.CLIENT.overHeadLevelColor.get()).intValue())));
        }
        if (!showTrait) {
            return ans;
        }
        MutableComponent temp = null;
        int count = 0;
        for (Map.Entry<MobTrait, Integer> e : this.traits.entrySet()) {
            MutableComponent comp = e.getKey().getFullDesc(e.getValue());
            if (temp == null) {
                temp = comp;
                count = 1;
                continue;
            }
            temp.m_7220_((Component)Component.m_237113_((String)" / ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)comp);
            if (++count < 3) continue;
            ans.add((Component)temp);
            count = 0;
            temp = null;
        }
        if (count > 0) {
            ans.add((Component)temp);
        }
        return ans;
    }

    public static enum Stage {
        PRE_INIT,
        INIT,
        POST_INIT;

    }
}

