/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.capability.mob;

import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.RegionalDifficultyModifier;
import dev.xkmc.l2hostility.content.capability.mob.MinionData;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.traits.legendary.MasterTrait;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@SerialClass
public class MasterData {
    @SerialClass.SerialField(toClient=true)
    public ArrayList<Minion> data = new ArrayList();
    @SerialClass.SerialField
    private LinkedHashMap<EntityType<?>, Data> map = new LinkedHashMap();

    @Nullable
    public static BlockPos getRandomPos(ServerLevel sl, EntityType<?> type, LivingEntity mob, int r, int round) {
        BlockPos pos = mob.m_20183_();
        Vec3 eye = mob.m_146892_();
        RandomSource rand = mob.m_217043_();
        for (int i = 0; i < round; ++i) {
            Vec3 e;
            BlockHitResult bhit;
            BlockPos p = pos.m_7918_(rand.m_216339_(0, r * 2 + 1) - r, rand.m_216339_(0, 3), rand.m_216339_(0, r * 2 + 1) - r);
            if (!sl.m_45772_(type.m_20585_((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_())) || (bhit = sl.m_45547_(new ClipContext(eye, e = Vec3.m_82539_((Vec3i)p).m_82520_(0.0, (double)(type.m_20679_() / 2.0f), 0.0), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null))).m_6662_() != HitResult.Type.MISS) continue;
            return p;
        }
        return null;
    }

    public boolean tick(MobTraitCap cap, Mob mob) {
        EntityConfig.MasterConfig config = MasterTrait.getConfig(mob.m_6095_());
        if (config == null) {
            return false;
        }
        for (EntityConfig.Minion minion : config.minions()) {
            this.map.computeIfAbsent(minion.type(), k -> new Data()).setup(minion);
        }
        boolean updated = this.data.removeIf(e -> {
            e.tick(mob);
            if (e.minion == null) {
                return !mob.m_9236_().m_5776_();
            }
            Data ent = this.map.get(e.minion.m_6095_());
            if (ent != null) {
                ++ent.count;
            }
            return false;
        });
        if (!mob.m_9236_().m_5776_()) {
            for (Minion minion : this.data) {
                if (minion.minion == null) continue;
                if (minion.minion.m_5448_() == null && mob.m_5448_() != null) {
                    minion.minion.m_6710_(mob.m_5448_());
                }
                if (minion.id == minion.minion.m_19879_()) continue;
                minion.id = minion.minion.m_19879_();
                updated = true;
            }
        }
        for (Data data : this.map.values()) {
            if (data.count >= data.config.maxCount() || data.cooldown <= 0) continue;
            --data.cooldown;
        }
        Level level = mob.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (mob.m_5448_() != null && mob.m_5448_().m_6084_() && this.data.size() < config.maxTotalCount() && mob.f_19797_ % config.spawnInterval() == 0) {
                for (Data e4 : this.map.values()) {
                    Minion nd;
                    if (e4.cooldown > 0 || this.data.size() >= config.maxTotalCount() || e4.count >= e4.config.maxCount() || cap.getLevel() < e4.config.minLevel() || (nd = e4.spawn(cap, serverLevel, mob)) == null) continue;
                    this.data.add(nd);
                    e4.cooldown = e4.config.cooldown();
                    return true;
                }
            }
        }
        return updated;
    }

    @SerialClass
    public static class Data {
        private EntityConfig.Minion config;
        private int count;
        @SerialClass.SerialField
        public int cooldown;

        public void setup(EntityConfig.Minion e) {
            this.config = e;
            this.count = 0;
        }

        @Nullable
        public Minion spawn(MobTraitCap parent, ServerLevel sl, Mob mob) {
            int r = this.config.spawnRange();
            BlockPos target = MasterData.getRandomPos(sl, this.config.type(), (LivingEntity)mob, r / 2, 16);
            if (target == null) {
                return null;
            }
            Entity e = this.config.type().m_262451_(sl, null, null, target, MobSpawnType.MOB_SUMMONED, false, false);
            if (!(e instanceof Mob)) {
                return null;
            }
            Mob m = (Mob)e;
            MobTraitCap cap = (MobTraitCap)MobTraitCap.HOLDER.get((ICapabilityProvider)m);
            RegionalDifficultyModifier diff = (p, c) -> {
                if (this.config.copyLevel()) {
                    c.base = parent.getLevel();
                } else {
                    ChunkDifficulty.at((Level)sl, p).ifPresent(x -> x.modifyInstance(p, c));
                }
                if (this.config.copyTrait()) {
                    cap.traits.putAll(parent.traits);
                    c.delegateTrait();
                }
            };
            if (this.config.traits() != null) {
                cap.setConfigCache(this.config.traits());
            }
            cap.minion = true;
            cap.asMinion = new MinionData().init(mob, this.config);
            cap.init((Level)sl, (LivingEntity)m, diff);
            m.m_6710_(mob.m_5448_());
            sl.m_7967_((Entity)m);
            Minion ans = new Minion();
            ans.minion = m;
            ans.uuid = m.m_20148_();
            ans.id = m.m_19879_();
            return ans;
        }
    }

    @SerialClass
    public static class Minion {
        @SerialClass.SerialField(toClient=true)
        public UUID uuid;
        @SerialClass.SerialField(toClient=true)
        public int id;
        public Mob minion;

        public void tick(Mob mob) {
            Mob m;
            Entity e;
            Level level = mob.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                if (this.minion == null && (e = sl.m_8791_(this.uuid)) instanceof Mob) {
                    Mob m2;
                    this.minion = m2 = (Mob)e;
                }
                if (this.minion != null && !this.minion.m_6084_()) {
                    this.minion = null;
                }
            } else if (this.minion == null && (e = mob.m_9236_().m_6815_(this.id)) instanceof Mob && (m = (Mob)e).m_20148_().equals(this.uuid)) {
                this.minion = m;
            }
        }
    }
}

