/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.capability.chunk;

import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.WorldDifficultyConfig;
import dev.xkmc.l2hostility.content.logic.DifficultyLevel;
import dev.xkmc.l2hostility.content.logic.LevelEditor;
import dev.xkmc.l2hostility.content.logic.MobDifficultyCollector;
import dev.xkmc.l2hostility.events.CapabilityEvents;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunkSection;

@SerialClass
public class SectionDifficulty {
    @SerialClass.SerialField
    int index;
    @SerialClass.SerialField
    public BlockPos activePos = null;
    @SerialClass.SerialField(toClient=true)
    private final DifficultyLevel difficulty = new DifficultyLevel();
    @SerialClass.SerialField(toClient=true)
    private SectionStage stage = SectionStage.INIT;
    LevelChunkSection section;

    public static Optional<SectionDifficulty> sectionAt(Level level, BlockPos pos) {
        return ChunkDifficulty.at(level, pos).map(e -> e.getSection(pos.m_123342_()));
    }

    public void modifyInstance(Level level, BlockPos pos, MobDifficultyCollector instance) {
        this.modifyInstanceInternal(level, pos, instance);
        if (((Boolean)LHConfig.COMMON.allowSectionDifficulty.get()).booleanValue()) {
            instance.acceptBonusLevel(this.difficulty.getLevel());
        }
        if (this.stage == SectionStage.CLEARED) {
            instance.setCap(0);
        }
    }

    private void modifyInstanceInternal(Level level, BlockPos pos, MobDifficultyCollector instance) {
        WorldDifficultyConfig.DifficultyConfig levelDiff = ((WorldDifficultyConfig)L2Hostility.DIFFICULTY.getMerged()).levelMap.get(level.m_46472_().m_135782_());
        if (levelDiff == null) {
            levelDiff = WorldDifficultyConfig.defaultLevel();
        }
        instance.acceptConfig(levelDiff);
        Holder biome = level.m_204166_(pos);
        biome.m_203543_().map(e -> ((WorldDifficultyConfig)L2Hostility.DIFFICULTY.getMerged()).biomeMap.get(e.m_135782_())).ifPresent(instance::acceptConfig);
        instance.acceptBonusLevel((int)Math.round((Double)LHConfig.COMMON.distanceFactor.get() * Math.sqrt(1.0 * (double)pos.m_123341_() * (double)pos.m_123341_() + 1.0 * (double)pos.m_123343_() * (double)pos.m_123343_())));
    }

    public List<Component> getSectionDifficultyDetail(Player player) {
        if (this.isCleared()) {
            return List.of();
        }
        WorldDifficultyConfig.DifficultyConfig levelDiff = ((WorldDifficultyConfig)L2Hostility.DIFFICULTY.getMerged()).levelMap.get(player.m_9236_().m_46472_().m_135782_());
        int dim = levelDiff == null ? WorldDifficultyConfig.defaultLevel().base() : levelDiff.base();
        BlockPos pos = player.m_20183_();
        Holder biome = player.m_9236_().m_204166_(pos);
        int bio = biome.m_203543_().map(e -> ((WorldDifficultyConfig)L2Hostility.DIFFICULTY.getMerged()).biomeMap.get(e.m_135782_())).map(WorldDifficultyConfig.DifficultyConfig::base).orElse(0);
        int dist = (int)Math.round((Double)LHConfig.COMMON.distanceFactor.get() * Math.sqrt(pos.m_123341_() * pos.m_123341_() + pos.m_123343_() * pos.m_123343_()));
        int adaptive = this.difficulty.getLevel();
        return List.of(LangData.INFO_SECTION_DIM_LEVEL.get(dim).m_130940_(ChatFormatting.GRAY), LangData.INFO_SECTION_BIOME_LEVEL.get(bio).m_130940_(ChatFormatting.GRAY), LangData.INFO_SECTION_DISTANCE_LEVEL.get(dist).m_130940_(ChatFormatting.GRAY), LangData.INFO_SECTION_ADAPTIVE_LEVEL.get(adaptive).m_130940_(ChatFormatting.GRAY));
    }

    public List<Component> getSectionScaleDetail(Player player) {
        if (this.isCleared()) {
            return List.of();
        }
        WorldDifficultyConfig.DifficultyConfig levelDiff = ((WorldDifficultyConfig)L2Hostility.DIFFICULTY.getMerged()).levelMap.get(player.m_9236_().m_46472_().m_135782_());
        double dim = levelDiff == null ? WorldDifficultyConfig.defaultLevel().scale() : levelDiff.scale();
        BlockPos pos = player.m_20183_();
        Holder biome = player.m_9236_().m_204166_(pos);
        double bio = biome.m_203543_().map(e -> ((WorldDifficultyConfig)L2Hostility.DIFFICULTY.getMerged()).biomeMap.get(e.m_135782_())).map(WorldDifficultyConfig.DifficultyConfig::scale).orElse(0.0);
        double pl = player.m_21133_((Attribute)LHMiscs.ADD_SCALE.get());
        return List.of(LangData.INFO_DIM_SCALE.get(dim).m_130940_(ChatFormatting.GRAY), LangData.INFO_BIOME_SCALE.get(bio).m_130940_(ChatFormatting.GRAY), LangData.INFO_PLAYER_SCALE.get(pl).m_130940_(ChatFormatting.GRAY));
    }

    public boolean isCleared() {
        return this.stage == SectionStage.CLEARED;
    }

    public boolean setClear(ChunkDifficulty chunk, BlockPos pos) {
        if (this.stage == SectionStage.CLEARED) {
            return false;
        }
        this.stage = SectionStage.CLEARED;
        CapabilityEvents.markDirty(chunk);
        chunk.chunk.m_8092_(true);
        return true;
    }

    public boolean setUnclear(ChunkDifficulty chunk, BlockPos pos) {
        if (this.stage == SectionStage.INIT) {
            return false;
        }
        this.stage = SectionStage.INIT;
        CapabilityEvents.markDirty(chunk);
        chunk.chunk.m_8092_(true);
        return true;
    }

    public void addKillHistory(ChunkDifficulty chunk, Player player, LivingEntity mob, MobTraitCap cap) {
        this.difficulty.grow(1.0, cap);
        CapabilityEvents.markDirty(chunk);
        chunk.chunk.m_8092_(true);
    }

    public LevelEditor getLevelEditor(Level level, BlockPos pos) {
        MobDifficultyCollector col = new MobDifficultyCollector();
        this.modifyInstanceInternal(level, pos, col);
        DifficultyLevel diff = (Boolean)LHConfig.COMMON.allowSectionDifficulty.get() != false ? this.difficulty : new DifficultyLevel();
        return new LevelEditor(diff, col.getBase());
    }

    public double getScale(Level level, BlockPos pos) {
        MobDifficultyCollector col = new MobDifficultyCollector();
        this.modifyInstanceInternal(level, pos, col);
        return col.scale;
    }

    public static enum SectionStage {
        INIT,
        CLEARED;

    }
}

