/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.capability.chunk;

import dev.xkmc.l2hostility.content.capability.chunk.RegionalDifficultyModifier;
import dev.xkmc.l2hostility.content.capability.chunk.SectionDifficulty;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.logic.MobDifficultyCollector;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

@SerialClass
public class ChunkDifficulty
implements RegionalDifficultyModifier {
    public static Capability<ChunkDifficulty> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkDifficulty>(){});
    public final LevelChunk chunk;
    @SerialClass.SerialField
    private ChunkStage stage = ChunkStage.PRE_INIT;
    @SerialClass.SerialField(toClient=true)
    private SectionDifficulty[] sections;

    public static Optional<ChunkDifficulty> at(Level level, BlockPos pos) {
        return ChunkDifficulty.at(level, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static Optional<ChunkDifficulty> at(Level level, int x, int z) {
        ChunkAccess chunk = level.m_6522_(x, z, ChunkStatus.f_62320_, false);
        if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk im = (ImposterProtoChunk)chunk;
            chunk = im.m_62768_();
        }
        if (chunk instanceof LevelChunk) {
            LevelChunk c = (LevelChunk)chunk;
            return c.getCapability(CAPABILITY).resolve();
        }
        return Optional.empty();
    }

    protected ChunkDifficulty(LevelChunk chunk) {
        this.chunk = chunk;
    }

    private void check() {
        if (this.stage != ChunkStage.PRE_INIT) {
            return;
        }
        this.stage = ChunkStage.INIT;
    }

    public SectionDifficulty getSection(int y) {
        int index = (y >> 4) - this.chunk.m_151560_();
        index = Mth.m_14045_((int)index, (int)0, (int)(this.sections.length - 1));
        return this.sections[index];
    }

    @Override
    public void modifyInstance(BlockPos pos, MobDifficultyCollector instance) {
        this.check();
        this.getSection(pos.m_123342_()).modifyInstance(this.chunk.m_62953_(), pos, instance);
    }

    public void addKillHistory(Player player, LivingEntity mob, MobTraitCap cap) {
        BlockPos pos = mob.m_20183_();
        int index = -this.chunk.m_151560_() + (pos.m_123342_() >> 4);
        if (index >= 0 && index < this.sections.length) {
            this.sections[index].addKillHistory(this, player, mob, cap);
        }
    }

    @SerialClass.OnInject
    public void init() {
        int i;
        int size = this.chunk.m_62953_().m_151559_();
        if (this.sections == null || this.sections.length != size) {
            this.sections = new SectionDifficulty[size];
            for (i = 0; i < size; ++i) {
                this.sections[i] = new SectionDifficulty();
                this.sections[i].index = this.chunk.m_151560_() + i;
            }
        }
        for (i = 0; i < size; ++i) {
            this.sections[i].section = this.chunk.m_183278_(i);
        }
    }

    public static void register() {
    }

    public static enum ChunkStage {
        PRE_INIT,
        INIT;

    }
}

