/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.compat.gateway;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.gate.BossEventSettings;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.GateRules;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.SpawnAlgorithms;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.ApplicationMode;
import dev.shadowsoffire.gateways.gate.normal.NormalGateway;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2hostility.compat.gateway.GatewayCondition;
import dev.xkmc.l2hostility.compat.gateway.GatewayRecipe;
import dev.xkmc.l2hostility.compat.gateway.HostilityGateways;
import dev.xkmc.l2hostility.compat.gateway.PlaceboCodecDataGen;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.RecipeGen;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.ConfigDataProvider;
import dev.xkmc.l2library.serial.recipe.ConditionalRecipeWrapper;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GatewayConfigGen
extends PlaceboCodecDataGen<Gateway> {
    public static final List<HostilityGateways> GATEWAYS = List.of(GatewayConfigGen.slimeGate(), GatewayConfigGen.splitGate());

    private static HostilityGateways slimeGate() {
        EntityConfig.TraitBase g2 = EntityConfig.trait((MobTrait)((Object)LHTraits.GROWTH.get()), 2, 2);
        EntityConfig.TraitBase g3 = EntityConfig.trait((MobTrait)((Object)LHTraits.GROWTH.get()), 2, 3);
        EntityConfig.TraitBase t2 = EntityConfig.trait((MobTrait)((Object)LHTraits.TANK.get()), 2, 2);
        EntityConfig.TraitBase t3 = EntityConfig.trait((MobTrait)((Object)LHTraits.TANK.get()), 2, 3);
        EntityConfig.TraitBase t4 = EntityConfig.trait((MobTrait)((Object)LHTraits.TANK.get()), 3, 4);
        EntityConfig.TraitBase adaptive = EntityConfig.trait((MobTrait)((Object)LHTraits.ADAPTIVE.get()), 2, 2);
        EntityConfig.TraitBase strike = EntityConfig.trait((MobTrait)((Object)LHTraits.STRIKE.get()), 1, 1);
        EntityConfig.TraitBase reflect = EntityConfig.trait((MobTrait)((Object)LHTraits.REFLECT.get()), 2, 2);
        EntityConfig.TraitBase dem = EntityConfig.trait((MobTrait)((Object)LHTraits.DEMENTOR.get()), 1, 1);
        EntityConfig.TraitBase dis = EntityConfig.trait((MobTrait)((Object)LHTraits.DISPELL.get()), 1, 1);
        return new HostilityGateways((MobTrait)((Object)LHTraits.GROWTH.get()), 2, 2000, (ItemLike)Items.f_42518_, List.of(GatewayConfigGen.wave(100, 1200, GatewayConfigGen.slime(EntityType.f_20526_, 2, 4)), GatewayConfigGen.wave(100, 1800, GatewayConfigGen.slime(EntityType.f_20526_, 2, 3), GatewayConfigGen.slime(EntityType.f_20468_, 2, 1)), GatewayConfigGen.wave(120, 2400, GatewayConfigGen.slime(EntityType.f_20526_, 2, 2), GatewayConfigGen.slime(EntityType.f_20468_, 2, 2)), GatewayConfigGen.wave(120, 3000, GatewayConfigGen.slime(EntityType.f_20526_, 3, 1), GatewayConfigGen.slime(EntityType.f_20468_, 3, 1), GatewayConfigGen.slime(EntityType.f_20526_, 2, 2), GatewayConfigGen.slime(EntityType.f_20468_, 2, 2)), GatewayConfigGen.wave(140, 3600, GatewayConfigGen.slime(EntityType.f_20526_, 3, 3), GatewayConfigGen.slime(EntityType.f_20468_, 3, 3))), List.of(e -> GatewayConfigGen.config(e, 3, -1, 1, 150, 80, EntityType.f_20526_).trait(List.of(g3, t4, strike, dem)), e -> GatewayConfigGen.config(e, 3, -1, 1, 150, 80, EntityType.f_20468_).trait(List.of(g3, adaptive, reflect, dis)), e -> GatewayConfigGen.config(e, 2, -1, 1, 130, 70, EntityType.f_20526_).trait(List.of(g3, t3, strike)), e -> GatewayConfigGen.config(e, 2, -1, 1, 130, 70, EntityType.f_20468_).trait(List.of(g3, adaptive, reflect)), e -> GatewayConfigGen.config(e, 1, -1, 1, 120, 60, EntityType.f_20526_).trait(List.of(g2, t2)), e -> GatewayConfigGen.config(e, 1, -1, 1, 120, 60, EntityType.f_20468_).trait(List.of(g2, adaptive)), e -> GatewayConfigGen.config(e, 0, -1, 100, 100, 50, EntityType.f_20526_, EntityType.f_20468_).trait(List.of(g2))));
    }

    private static HostilityGateways splitGate() {
        EntityType[] types = new EntityType[]{EntityType.f_20501_, EntityType.f_20562_, EntityType.f_20458_, EntityType.f_20524_, EntityType.f_20497_, EntityType.f_20481_};
        EntityConfig.TraitBase g1 = EntityConfig.trait((MobTrait)((Object)LHTraits.SPLIT.get()), 1, 1);
        EntityConfig.TraitBase g2 = EntityConfig.trait((MobTrait)((Object)LHTraits.SPLIT.get()), 1, 2);
        EntityConfig.TraitBase g3 = EntityConfig.trait((MobTrait)((Object)LHTraits.SPLIT.get()), 2, 3);
        return new HostilityGateways((MobTrait)((Object)LHTraits.SPLIT.get()), 2, 2000, (ItemLike)Items.f_42583_, List.of(GatewayConfigGen.wave(100, 1200, GatewayConfigGen.entity(EntityType.f_20501_, 4)), GatewayConfigGen.wave(100, 1800, GatewayConfigGen.entity(EntityType.f_20524_, 2), GatewayConfigGen.entity(EntityType.f_20501_, 2)), GatewayConfigGen.wave(120, 2400, GatewayConfigGen.entity(EntityType.f_20562_, 2), GatewayConfigGen.entity(EntityType.f_20524_, 2), GatewayConfigGen.entity(EntityType.f_20458_, 2)), GatewayConfigGen.wave(120, 3000, GatewayConfigGen.entity(EntityType.f_20562_, 2), GatewayConfigGen.entity(EntityType.f_20497_, 2), GatewayConfigGen.entity(EntityType.f_20481_, 1), GatewayConfigGen.entity(EntityType.f_20501_, 1), GatewayConfigGen.entity(EntityType.f_20458_, 1), GatewayConfigGen.entity(EntityType.f_20524_, 1)), GatewayConfigGen.wave(140, 3600, GatewayConfigGen.entity(EntityType.f_20491_, 2), GatewayConfigGen.entity(EntityType.f_20554_, 2), GatewayConfigGen.entity(EntityType.f_20501_, 1), GatewayConfigGen.entity(EntityType.f_20458_, 1), GatewayConfigGen.entity(EntityType.f_20524_, 1), GatewayConfigGen.entity(EntityType.f_20562_, 1), GatewayConfigGen.entity(EntityType.f_20497_, 1), GatewayConfigGen.entity(EntityType.f_20481_, 1))), List.of(e -> GatewayConfigGen.config(e, 0, 0, 10, 100, 50, types).trait(List.of(g1)), e -> GatewayConfigGen.config(e, 1, 2, 10, 120, 70, types).trait(List.of(g2)), e -> GatewayConfigGen.config(e, 3, 4, 10, 140, 90, types).trait(List.of(g3))));
    }

    public GatewayConfigGen(DataGenerator generator) {
        super(generator, "L2Hostility x Gateways Compat");
        WaveModifier.initSerializers();
        Reward.initSerializers();
        WaveEntity.initSerializers();
        Failure.initSerializers();
        ApplicationMode.initSerializers();
    }

    public static void genConfig(ConfigDataProvider.Collector collector) {
        for (HostilityGateways e : GATEWAYS) {
            EntityConfig config = new EntityConfig();
            e.configs().forEach(x -> config.put((EntityConfig.Config)x.apply(e.path())));
            collector.add(L2Hostility.ENTITY, new ResourceLocation("gateways", e.trait().getRegistryName().m_135815_()), (BaseConfig)config);
        }
    }

    public static void genRecipe(RegistrateRecipeProvider pvd) {
        for (HostilityGateways e : GATEWAYS) {
            RecipeGen.unlock(pvd, (arg_0, arg_1) -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)GatewayObjects.GATE_PEARL.get()), (int)1)).m_126132_(arg_0, arg_1), (Item)LCItems.VOID_EYE.get()).m_126130_("1A1").m_126130_("ABA").m_126130_("1A1").m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42584_).m_126127_(Character.valueOf('A'), LHItems.HOSTILITY_ESSENCE).m_126127_(Character.valueOf('1'), e.mat()).m_126140_(x -> ConditionalRecipeWrapper.mod((RegistrateRecipeProvider)pvd, (String[])new String[]{"gateways"}).accept(new GatewayRecipe((FinishedRecipe)x, e.path())), e.path());
        }
    }

    public static void genLang(RegistrateLangProvider pvd) {
        for (HostilityGateways e : GATEWAYS) {
            pvd.add(e.path().toString().replace(':', '.'), RegistrateLangProvider.toEnglishName((String)e.trait().getRegistryName().m_135815_()) + " Gateway");
        }
    }

    @Override
    public void add(BiConsumer<String, Gateway> map) {
        for (HostilityGateways e : GATEWAYS) {
            this.add(map, e);
        }
    }

    private void add(BiConsumer<String, Gateway> map, HostilityGateways gate) {
        map.accept("gateways/gateways/hostility/" + gate.trait().getRegistryName().m_135815_(), (Gateway)new NormalGateway(Gateway.Size.MEDIUM, TextColor.m_131266_((int)gate.trait().getColor()), gate.waves(), List.of(new Reward.StackReward(new ItemStack((ItemLike)gate.trait().m_5456_(), gate.count())), new Reward.XpReward(gate.xp(), gate.xp() / 10)), List.of(), SpawnAlgorithms.OPEN_FIELD, GateRules.DEFAULT, BossEventSettings.DEFAULT));
    }

    private static Wave wave(int setup, int max, WaveEntity ... entities) {
        return new Wave(List.of(entities), List.of(), List.of(), max, setup);
    }

    private static WaveEntity entity(EntityType<?> type, int count) {
        return new WaveEntity.StandardWaveEntity(type, Optional.empty(), Optional.empty(), List.of(), false, count);
    }

    private static WaveEntity slime(EntityType<?> type, int size, int count) {
        return new WaveEntity.StandardWaveEntity(type, Optional.empty(), Optional.of((CompoundTag)Util.m_137469_((Object)new CompoundTag(), e -> e.m_128405_("Size", (1 << size) - 1))), List.of(), false, count);
    }

    private static EntityConfig.Config config(ResourceLocation id, int start, int end, int count, int min, int base, EntityType<?> ... types) {
        return EntityConfig.entity(min, base, 0.0, 0.0, List.of(types)).conditions(GatewayCondition.of(id, start, end, count, 1.0)).blacklist((MobTrait)((Object)LHTraits.MOONWALK.get()), (MobTrait)((Object)LHTraits.GRAVITY.get()), (MobTrait)((Object)LHTraits.INVISIBLE.get()));
    }
}

