/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.compat.gateway;

import dev.xkmc.l2hostility.compat.gateway.WaveData;
import dev.xkmc.l2hostility.content.config.SpecialConfigCondition;
import dev.xkmc.l2serial.serialization.SerialClass;
import net.minecraft.resources.ResourceLocation;

@SerialClass
public class GatewayCondition
extends SpecialConfigCondition<WaveData> {
    @SerialClass.SerialField
    public int minWave;
    @SerialClass.SerialField
    public int maxWave;
    @SerialClass.SerialField
    public int maxCount;
    @SerialClass.SerialField
    public double chance;

    public static GatewayCondition of(ResourceLocation id, int minWave, int count, double chance) {
        return GatewayCondition.of(id, minWave, -1, count, chance);
    }

    public static GatewayCondition of(ResourceLocation id, int minWave, int maxWave, int count, double chance) {
        GatewayCondition ans = new GatewayCondition();
        ans.id = id;
        ans.minWave = minWave;
        ans.maxWave = maxWave;
        ans.maxCount = count;
        ans.chance = chance;
        return ans;
    }

    public GatewayCondition() {
        super(WaveData.class);
    }

    @Override
    public boolean test(WaveData wave) {
        int index = wave.id.wave();
        if (index < this.minWave || this.maxWave >= 0 && index > this.maxWave) {
            return false;
        }
        int val = wave.appliedCount.getOrDefault(this, 0);
        if (val >= this.maxCount) {
            return false;
        }
        wave.appliedCount.put(this, val + 1);
        return true;
    }
}

