/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateManager;
import com.supermartijn642.formations.tools.template.TemplateRenderer;
import com.supermartijn642.formations.tools.template.packets.CreateTemplatePacket;
import com.supermartijn642.formations.tools.template.packets.DeleteTemplatePacket;
import com.supermartijn642.formations.tools.template.screen.TemplateEditButton;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TemplateEditingScreen
extends BaseWidget {
    private static final ResourceLocation SCREEN_BACKGROUND = Formations.location("textures/gui/template_creation_screen.png");
    private final Template template;
    private TemplateEditButton saveButton;

    public TemplateEditingScreen(Template template) {
        super(0, 0, 144, 166);
        this.template = template;
    }

    public Component getNarrationMessage() {
        return this.template == null ? TextComponents.translation((String)"formations.template.edit.new_template").get() : TextComponents.translation((String)"formations.template.edit.edit_template").get();
    }

    public void addWidgets() {
        if (this.template == null) {
            TextFieldWidget nameField = new TextFieldWidget(8, 32, 128, 12, "", 50, t -> {
                this.saveButton.active = Template.isValidName(t) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(t.trim()) == null;
            });
            nameField.setSuggestion(I18n.m_118938_((String)"formations.template.edit.name_hint", (Object[])new Object[0]));
            this.addWidget((Widget)nameField);
            this.addWidget((Widget)new TemplateEditButton(0, 151, 72, 15, (Component)TextComponents.translation((String)"formations.template.edit.cancel").get(), TemplateEditButton.LEFT_BUTTON, () -> {
                TemplateRenderer.selectionDimension = null;
                ClientUtils.getMinecraft().m_91152_(null);
            }));
            this.saveButton = new TemplateEditButton(72, 151, 72, 15, (Component)TextComponents.translation((String)"formations.template.edit.save").get(), TemplateEditButton.GREEN_RIGHT_BUTTON, () -> {
                String name = nameField.getText().trim();
                if (Template.isValidName(name) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(name) == null) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new CreateTemplatePacket(Template.create(new AABB(TemplateRenderer.selectionPos1).m_82367_(new AABB(TemplateRenderer.selectionPos2)), name)));
                    TemplateRenderer.selectionDimension = null;
                    ClientUtils.getMinecraft().m_91152_(null);
                }
            });
            this.saveButton.active = false;
            this.addWidget((Widget)this.saveButton);
        } else {
            TextFieldWidget nameField = new TextFieldWidget(8, 32, 128, 12, this.template.getName(), 50, t -> {
                this.saveButton.active = Template.isValidName(t) && (t.trim().equals(this.template.getName()) || TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(t.trim()) == null);
            });
            nameField.setSuggestion(I18n.m_118938_((String)"formations.template.edit.name_hint", (Object[])new Object[0]));
            this.addWidget((Widget)nameField);
            this.addWidget((Widget)new TemplateEditButton(0, 151, 72, 15, (Component)TextComponents.translation((String)"formations.template.edit.delete").get(), TemplateEditButton.RED_LEFT_BUTTON, () -> {
                FormationsDev.CHANNEL.sendToServer((BasePacket)new DeleteTemplatePacket(this.template));
                ClientUtils.getMinecraft().m_91152_(null);
            }));
            this.saveButton = new TemplateEditButton(72, 151, 72, 15, (Component)TextComponents.translation((String)"formations.template.edit.confirm").get(), TemplateEditButton.RIGHT_BUTTON, () -> {
                String name = nameField.getText().trim();
                if (name.equals(this.template.getName())) {
                    ClientUtils.getMinecraft().m_91152_(null);
                } else if (Template.isValidName(name) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(name) == null) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new CreateTemplatePacket(Template.create(this.template.getArea(), name)));
                    ClientUtils.getMinecraft().m_91152_(null);
                }
            });
            this.saveButton.active = true;
            this.addWidget((Widget)this.saveButton);
        }
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((ResourceLocation)SCREEN_BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.left(), (float)this.top(), (float)this.width, (float)this.height, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        super.renderBackground(context, mouseX, mouseY);
    }

    public void renderForeground(WidgetRenderContext context, int mouseX, int mouseY) {
        super.renderForeground(context, mouseX, mouseY);
        AABB area = this.template == null ? new AABB(TemplateRenderer.selectionPos1).m_82367_(new AABB(TemplateRenderer.selectionPos2)) : this.template.getArea();
        Vec3 center = area.m_82399_();
        ScreenUtils.drawCenteredStringWithShadow((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.new_template").get(), (float)72.0f, (float)3.0f, (int)0xE0E0E0);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.name").get(), (float)32.0f, (float)22.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.location").get(), (float)32.0f, (float)51.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.location.x").get(), (float)10.0f, (float)63.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.location.y").get(), (float)10.0f, (float)74.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.location.z").get(), (float)10.0f, (float)85.0f);
        Font font = ClientUtils.getFontRenderer();
        MutableComponent posX = TextComponents.number((double)center.f_82479_, (int)1).get();
        MutableComponent posY = TextComponents.number((double)center.f_82480_, (int)1).get();
        MutableComponent posZ = TextComponents.number((double)center.f_82481_, (int)1).get();
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)posX, (float)(132 - font.m_92852_((FormattedText)posX)), (float)63.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)posY, (float)(132 - font.m_92852_((FormattedText)posY)), (float)74.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)posZ, (float)(132 - font.m_92852_((FormattedText)posZ)), (float)85.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.size").get(), (float)32.0f, (float)101.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.size.x").get(), (float)10.0f, (float)113.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.size.y").get(), (float)10.0f, (float)124.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.template.edit.size.z").get(), (float)10.0f, (float)135.0f);
        MutableComponent sizeX = TextComponents.number((int)((int)area.m_82362_())).get();
        MutableComponent sizeY = TextComponents.number((int)((int)area.m_82376_())).get();
        MutableComponent sizeZ = TextComponents.number((int)((int)area.m_82385_())).get();
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)sizeX, (float)(132 - font.m_92852_((FormattedText)sizeX)), (float)113.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)sizeY, (float)(132 - font.m_92852_((FormattedText)sizeY)), (float)124.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)sizeZ, (float)(132 - font.m_92852_((FormattedText)sizeZ)), (float)135.0f);
    }
}

