/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateEditorItem;
import com.supermartijn642.formations.tools.template.TemplateManager;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

public class TemplateRenderer {
    public static ResourceKey<Level> selectionDimension;
    public static BlockPos selectionPos1;
    public static BlockPos selectionPos2;

    public static void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(TemplateRenderer::renderTemplates);
    }

    public static Template getAimedAtTemplate() {
        HitResult hitResult = ClientUtils.getMinecraft().f_91077_;
        if (hitResult != null && hitResult.m_6662_() != HitResult.Type.MISS) {
            return null;
        }
        Vec3 playerPos = ClientUtils.getMinecraft().f_91063_.m_109153_().m_90583_();
        Vec3 playerFacingPos = new Vec3(ClientUtils.getMinecraft().f_91063_.m_109153_().m_90583_().m_252839_().add((Vector3fc)ClientUtils.getMinecraft().f_91063_.m_109153_().m_253058_().mul(100.0f)));
        Template aimedTemplate = null;
        double distance = 0.0;
        for (Template template : TemplateManager.get(ClientUtils.getWorld()).getAllTemplates()) {
            Optional<Double> d = template.getArea().m_82371_(playerPos, playerFacingPos).map(arg_0 -> ((Vec3)playerPos).m_82557_(arg_0));
            if (!d.isPresent() || aimedTemplate != null && !(d.get() < distance)) continue;
            aimedTemplate = template;
            distance = d.get();
        }
        return aimedTemplate;
    }

    private static void renderTemplates(RenderWorldEvent e) {
        e.getPoseStack().m_85836_();
        Vec3 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        TemplateManager.get(ClientUtils.getWorld()).getAllTemplates().stream().filter(template -> template.getArea().m_272282_(ClientUtils.getPlayer().m_20182_()) < 40000.0).forEach(template -> {
            RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)template.getArea().m_82400_(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f, (boolean)true);
            RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)template.getArea().m_82400_(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f, (boolean)true);
            TemplateRenderer.renderTemplateText(e.getPoseStack(), template);
        });
        if (!(ClientUtils.getPlayer().m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof TemplateEditorItem)) {
            e.getPoseStack().m_85849_();
            return;
        }
        if (ClientUtils.getWorld().m_46472_() == selectionDimension && selectionPos1 != null && selectionPos2 != null) {
            AABB box = new AABB(selectionPos1).m_82367_(new AABB(selectionPos2)).m_82400_(0.1);
            RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)box, (float)1.0f, (float)1.0f, (float)0.5f, (float)1.0f, (boolean)false);
            RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)box, (float)1.0f, (float)1.0f, (float)0.5f, (float)0.1f, (boolean)false);
            RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)box, (float)1.0f, (float)1.0f, (float)0.5f, (float)0.3f, (boolean)true);
        } else {
            Template aimedTemplate;
            if (ClientUtils.getWorld().m_46472_() == selectionDimension && (selectionPos1 != null || selectionPos2 != null)) {
                RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)new AABB(selectionPos1 == null ? selectionPos2 : selectionPos1), (float)1.0f, (float)1.0f, (float)0.5f, (float)1.0f, (boolean)false);
            }
            if ((aimedTemplate = TemplateRenderer.getAimedAtTemplate()) != null) {
                RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)aimedTemplate.getArea().m_82400_(0.1), (float)1.0f, (float)1.0f, (float)0.5f, (float)1.0f, (boolean)false);
                RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)aimedTemplate.getArea().m_82400_(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f, (boolean)false);
            }
        }
        e.getPoseStack().m_85849_();
    }

    private static void renderTemplateText(PoseStack poseStack, Template template) {
        AABB area = template.getArea();
        Font renderer = ClientUtils.getFontRenderer();
        int nameWidth = renderer.m_92895_(template.getName());
        Vec3 center = area.m_82399_();
        float f = ((float)area.m_82362_() + 1.0f) / (float)nameWidth;
        float f2 = (float)area.m_82376_() + 1.0f;
        Objects.requireNonNull(renderer);
        float xScaling = -Math.min(f, f2 / 9.0f) * 0.8f;
        float f3 = ((float)area.m_82385_() + 1.0f) / (float)nameWidth;
        float f4 = (float)area.m_82376_() + 1.0f;
        Objects.requireNonNull(renderer);
        float zScaling = -Math.min(f3, f4 / 9.0f) * 0.8f;
        poseStack.m_85836_();
        poseStack.m_85837_(center.f_82479_, center.f_82480_, area.f_82290_ - 0.1);
        poseStack.m_85841_(xScaling, xScaling, 1.0f);
        String string = template.getName();
        float f5 = (float)(-nameWidth) / 2.0f;
        Objects.requireNonNull(renderer);
        ScreenUtils.drawString((PoseStack)poseStack, (String)string, (float)f5, (float)((float)(-9) / 2.0f), (int)-922746881);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(center.f_82479_, center.f_82480_, area.f_82293_ + 0.1);
        poseStack.m_85841_(-xScaling, xScaling, 1.0f);
        String string2 = template.getName();
        float f6 = (float)(-nameWidth) / 2.0f;
        Objects.requireNonNull(renderer);
        ScreenUtils.drawString((PoseStack)poseStack, (String)string2, (float)f6, (float)((float)(-9) / 2.0f), (int)-922746881);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(area.f_82288_ - 0.1, center.f_82480_, center.f_82481_);
        poseStack.m_85841_(1.0f, zScaling, zScaling);
        poseStack.m_252781_(new Quaternionf().rotateAxis(1.5707964f, 0.0f, 1.0f, 0.0f));
        String string3 = template.getName();
        float f7 = (float)(-nameWidth) / 2.0f;
        Objects.requireNonNull(renderer);
        ScreenUtils.drawString((PoseStack)poseStack, (String)string3, (float)f7, (float)((float)(-9) / 2.0f), (int)-922746881);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(area.f_82291_ + 0.1, center.f_82480_, center.f_82481_);
        poseStack.m_85841_(1.0f, zScaling, -zScaling);
        poseStack.m_252781_(new Quaternionf().rotateAxis(1.5707964f, 0.0f, 1.0f, 0.0f));
        String string4 = template.getName();
        float f8 = (float)(-nameWidth) / 2.0f;
        Objects.requireNonNull(renderer);
        ScreenUtils.drawString((PoseStack)poseStack, (String)string4, (float)f8, (float)((float)(-9) / 2.0f), (int)-922746881);
        poseStack.m_85849_();
    }
}

