/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.tools.SyncFormationsLevelDataPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;

public class FormationsLevelData {
    public static FormationsLevelData SERVER = new FormationsLevelData();
    public static FormationsLevelData CLIENT = new FormationsLevelData();
    private boolean devMode;

    public static void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(event -> SERVER.syncToPlayer(event.getEntity()));
    }

    private FormationsLevelData() {
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        if (this.devMode == devMode) {
            return;
        }
        this.devMode = devMode;
        if (this == SERVER) {
            this.syncToAll();
        }
    }

    public void save(MinecraftServer server) {
        Path file = server.f_129744_.m_78283_(LevelResource.f_78182_).resolve("formations-data");
        try (OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);){
            stream.write(this.devMode ? 1 : 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(MinecraftServer server) {
        block9: {
            Path file = server.f_129744_.m_78283_(LevelResource.f_78182_).resolve("formations-data");
            if (Files.exists(file, new LinkOption[0])) {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    this.devMode = stream.read() == 1;
                    break block9;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.devMode = false;
        }
    }

    public void syncToPlayer(Player player) {
        FormationsDev.CHANNEL.sendToPlayer(player, (BasePacket)new SyncFormationsLevelDataPacket(this.devMode));
    }

    public void syncToAll() {
        FormationsDev.CHANNEL.sendToAllPlayers((BasePacket)new SyncFormationsLevelDataPacket(this.devMode));
    }
}

