/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.commons.lang3.tuple.Triple;

public enum StructurePlacement implements StringRepresentable
{
    SURFACE((context, box) -> StructurePlacement.findFromTop(context, box, Heightmap.Types.WORLD_SURFACE_WG, 10, 3.0, BlockBehaviour.BlockStateBase::m_280296_)),
    CEILING((context, box) -> {
        List positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()), context.f_226629_().m_151558_());
            NoiseColumn column = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
            for (int y = context.f_226629_().m_141937_() + 1; y < highest; ++y) {
                if (column.m_183556_(y).m_60795_()) continue;
                return pos.m_142448_(y);
            }
            return null;
        }).collect(Collectors.toList());
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int[] heights = positions.stream().mapToInt(Vec3i::m_123342_).toArray();
        int average = (int)Math.round(IntStream.of(heights).average().getAsDouble());
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).average().getAsDouble() > 4.0) {
            return null;
        }
        return average;
    }),
    ON_WATER((context, box) -> StructurePlacement.findFromTop(context, box, Heightmap.Types.WORLD_SURFACE_WG, 1, 1.0, state -> state.m_60713_(Blocks.f_49990_))),
    ON_LAVA((context, box) -> StructurePlacement.findFromTop(context, box, Heightmap.Types.WORLD_SURFACE_WG, 1, 1.0, state -> state.m_60713_(Blocks.f_49991_))),
    UNDERGROUND((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()), context.f_226629_().m_151558_());
            NoiseColumn column = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
            int lowest = context.f_226629_().m_141937_();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.m_183556_(y).m_60795_()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.f_226629_().m_141937_()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 <= box.m_71057_()) {
            return null;
        }
        return min + 1 + context.f_226626_().m_188503_(max - min - box.m_71057_() - 2);
    }),
    UNDERGROUND_SURFACE((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()), context.f_226629_().m_151558_());
            NoiseColumn column = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
            int lowest = context.f_226629_().m_141937_();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.m_183556_(y).m_60795_()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.f_226629_().m_141937_()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 <= box.m_71057_()) {
            return null;
        }
        int height = min + 1 + context.f_226626_().m_188503_(max - min - box.m_71057_() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            NoiseColumn column = (NoiseColumn)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.m_183556_(y).m_60795_(); --y, ++i) {
            }
            if (!column.m_183556_(y).m_60795_()) {
                return null;
            }
            --y;
            for (i = 0; i < 20 && column.m_183556_(y).m_60795_(); ++i) {
                --y;
            }
            if (!column.m_183556_(y).m_280296_()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_CEILING((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()), context.f_226629_().m_151558_());
            NoiseColumn column = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
            int lowest = context.f_226629_().m_141937_();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.m_183556_(y).m_60795_()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.f_226629_().m_141937_()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 <= box.m_71057_()) {
            return null;
        }
        int height = min + 1 + context.f_226626_().m_188503_(max - min - box.m_71057_() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            NoiseColumn column = (NoiseColumn)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.m_183556_(y).m_60795_(); ++y, ++i) {
            }
            if (!column.m_183556_(y).m_60795_()) {
                return null;
            }
            ++y;
            for (i = 0; i < 30 && column.m_183556_(y).m_60795_(); ++i) {
                ++y;
            }
            if (!column.m_183556_(y).m_280296_()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_BURIED((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()), context.f_226629_().m_151558_());
            NoiseColumn column = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
            int lowest = context.f_226629_().m_141937_();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.m_183556_(y).m_60795_()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.f_226629_().m_141937_()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 <= box.m_71057_()) {
            return null;
        }
        int ySpan = box.m_71057_();
        int height = min + ySpan + 1 + context.f_226626_().m_188503_(max - min - ySpan - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            NoiseColumn column = (NoiseColumn)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.m_183556_(y).m_280296_(); --y, ++i) {
            }
            if (!column.m_183556_(y).m_280296_()) {
                return null;
            }
            y -= 2;
            for (i = 0; i < ySpan; ++i) {
                if (!column.m_183556_(y).m_280296_()) {
                    return null;
                }
                --y;
            }
            if (!column.m_183556_(y).m_280296_() || !column.m_183556_(y - 1).m_280296_()) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (!positions.stream().allMatch(t -> {
            NoiseColumn column = (NoiseColumn)t.getLeft();
            return column.m_183556_(average).m_280296_() && column.m_183556_(average + ySpan).m_280296_();
        })) {
            return null;
        }
        return average;
    }),
    UNDERGROUND_ON_LAVA((context, box) -> {
        List<Triple> positions = StructurePlacement.cornersAndCenter(box).map(pos -> {
            int highest = Math.min(context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()), context.f_226629_().m_151558_());
            NoiseColumn column = context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_());
            int lowest = context.f_226629_().m_141937_();
            for (int y = lowest + 1; y < highest; ++y) {
                if (column.m_183556_(y).m_60795_()) continue;
                lowest = y;
                break;
            }
            if (lowest == context.f_226629_().m_141937_()) {
                return null;
            }
            return Triple.of((Object)column, (Object)highest, (Object)lowest);
        }).toList();
        if (positions.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        int min = positions.stream().mapToInt(Triple::getRight).max().getAsInt();
        int max = positions.stream().mapToInt(Triple::getMiddle).min().getAsInt();
        if (max - min - 2 <= box.m_71057_()) {
            return null;
        }
        int height = min + 1 + context.f_226626_().m_188503_(max - min - box.m_71057_() - 2);
        Integer[] heights = (Integer[])positions.stream().map(t -> {
            int i;
            NoiseColumn column = (NoiseColumn)t.getLeft();
            int y = height;
            for (i = 0; i < 10 && y > min && !column.m_183556_(y).m_60795_(); --y, ++i) {
            }
            if (!column.m_183556_(y).m_60795_()) {
                return null;
            }
            --y;
            for (i = 0; i < 40 && column.m_183556_(y).m_60795_(); ++i) {
                --y;
            }
            if (!column.m_183556_(y).m_60713_(Blocks.f_49991_)) {
                return null;
            }
            return y;
        }).toArray(Integer[]::new);
        if (Arrays.stream(heights).anyMatch(Objects::isNull)) {
            return null;
        }
        int average = (int)Math.round(Stream.of(heights).mapToInt(Integer::intValue).average().getAsDouble());
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).max().getAsInt() > 5) {
            return null;
        }
        if (Stream.of(heights).mapToInt(y -> Math.abs(average - y)).average().getAsDouble() > 3.0) {
            return null;
        }
        return average;
    });

    public static final Codec<StructurePlacement> CODEC;
    final BiFunction<Structure.GenerationContext, BoundingBox, Integer> locator;

    private StructurePlacement(BiFunction<Structure.GenerationContext, BoundingBox, Integer> locator) {
        this.locator = locator;
    }

    public Optional<Integer> findHeight(Structure.GenerationContext context, BoundingBox boundingBox) {
        return Optional.ofNullable(this.locator.apply(context, boundingBox));
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private static Stream<BlockPos.MutableBlockPos> cornersAndCenter(BoundingBox box) {
        BlockPos center = box.m_162394_();
        return Stream.of(new BlockPos.MutableBlockPos(box.m_162395_(), 0, box.m_162398_()), new BlockPos.MutableBlockPos(box.m_162395_(), 0, box.m_162401_()), new BlockPos.MutableBlockPos(box.m_162399_(), 0, box.m_162401_()), new BlockPos.MutableBlockPos(box.m_162399_(), 0, box.m_162398_()), new BlockPos.MutableBlockPos(center.m_123341_(), 0, center.m_123343_()));
    }

    private static Integer findFromTop(Structure.GenerationContext context, BoundingBox box, Heightmap.Types heightmap, int maxOffset, double maxAverageOffset, Predicate<BlockState> target) {
        List positions = StructurePlacement.cornersAndCenter(box).map(pos -> pos.m_142448_(context.f_226622_().m_223235_(pos.m_123341_(), pos.m_123343_(), heightmap, context.f_226629_(), context.f_226624_()))).collect(Collectors.toList());
        int[] heights = positions.stream().mapToInt(Vec3i::m_123342_).toArray();
        if (IntStream.of(heights).anyMatch(y -> y <= context.f_226629_().m_141937_())) {
            return null;
        }
        if (positions.stream().anyMatch(pos -> !target.test(context.f_226622_().m_214184_(pos.m_123341_(), pos.m_123343_(), context.f_226629_(), context.f_226624_()).m_183556_(pos.m_123342_())))) {
            return null;
        }
        int average = (int)Math.round(IntStream.of(heights).average().getAsDouble());
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).max().getAsInt() > maxOffset) {
            return null;
        }
        if (IntStream.of(heights).map(y -> Math.abs(average - y)).average().getAsDouble() > maxAverageOffset) {
            return null;
        }
        return average;
    }

    static {
        CODEC = StringRepresentable.m_216439_(StructurePlacement::values);
    }
}

