/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URIConverter
implements TypeConverter<URI> {
    @Override
    public URI convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof URI) {
            return (URI)value;
        }
        if (value instanceof File) {
            File file = (File)value;
            return file.toURI();
        }
        if (value instanceof URL) {
            URL url = (URL)value;
            try {
                return url.toURI();
            }
            catch (URISyntaxException usex) {
                throw new TypeConversionException(value, (Throwable)usex);
            }
        }
        try {
            return new URI(value.toString());
        }
        catch (URISyntaxException usex) {
            throw new TypeConversionException(value, (Throwable)usex);
        }
    }
}

