/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.time.JulianDate;
import com.hypherionmc.simplerpc.jodd.time.TimeUtil;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
implements TypeConverter<Date> {
    @Override
    public Date convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof JulianDate) {
            return new Date(((JulianDate)value).toMilliseconds());
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.toDate((LocalDateTime)value);
        }
        if (value instanceof LocalDate) {
            return TimeUtil.toDate((LocalDate)value);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            return TimeUtil.toDate(LocalDateTime.parse(stringValue));
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new Date(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

