/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.util.BlockChangeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.jetbrains.annotations.Nullable;

public class ChangeStorage {
    private static int storageIDs = 0;
    private final int id;
    private final Map<BlockPos, BlockChangeData> blocks = new HashMap<BlockPos, BlockChangeData>();
    private final List<CompoundTag> removedEntities = new ArrayList<CompoundTag>();
    private final List<Entity> addedEntities = new ArrayList<Entity>();
    private final Component operation;
    private Iterator<Map.Entry<BlockPos, BlockChangeData>> iterator = null;
    private final UUID player;

    public ChangeStorage(Component operation, UUID player) {
        this.player = player;
        this.id = storageIDs++;
        this.operation = operation;
    }

    public void addPreviousDataFor(BlockPos place, Level world) {
        this.blocks.computeIfAbsent(place, p -> new BlockChangeData()).withPreState(world.m_8055_(place)).withPreTE(world.m_7702_(place));
    }

    public void addPostDataFor(BlockPos place, Level world) {
        this.blocks.computeIfAbsent(place, p -> new BlockChangeData()).withPostState(world.m_8055_(place)).withPostTE(world.m_7702_(place));
    }

    public void addEntities(List<Entity> list) {
        this.removedEntities.addAll(list.stream().map(IForgeEntity::serializeNBT).collect(Collectors.toList()));
    }

    public void addToBeKilledEntity(Entity entity) {
        this.addedEntities.add(entity);
    }

    public boolean undo(Level world, @Nullable ChangeStorage undoStorage) {
        if (this.iterator == null) {
            this.iterator = this.blocks.entrySet().iterator();
        }
        int count = 0;
        while (this.iterator.hasNext()) {
            Map.Entry<BlockPos, BlockChangeData> entry = this.iterator.next();
            if (world.m_8055_(entry.getKey()) != entry.getValue().getPostState()) continue;
            if (undoStorage != null) {
                undoStorage.addPreviousDataFor(entry.getKey(), world);
            }
            world.m_46597_(entry.getKey(), entry.getValue().getPreState());
            if (entry.getValue().getPreTE() != null) {
                world.m_151523_(entry.getValue().getPreTE());
            }
            if (undoStorage != null) {
                undoStorage.addPostDataFor(entry.getKey(), world);
            }
            if (++count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
            return false;
        }
        for (CompoundTag data : this.removedEntities) {
            Entity entity;
            Optional type = EntityType.m_20637_((CompoundTag)data);
            if (!type.isPresent() || (entity = ((EntityType)type.get()).m_20615_(world)) == null) continue;
            entity.deserializeNBT(data);
            world.m_7967_(entity);
            if (undoStorage == null) continue;
            undoStorage.addedEntities.add(entity);
        }
        this.addedEntities.forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
        if (undoStorage != null) {
            Manager.addToUndoRedoCache(undoStorage);
        }
        return true;
    }

    public boolean redo(Level world) {
        int count = 0;
        if (this.iterator == null) {
            this.iterator = this.blocks.entrySet().iterator();
        }
        while (this.iterator.hasNext()) {
            Map.Entry<BlockPos, BlockChangeData> entry = this.iterator.next();
            if (world.m_8055_(entry.getKey()) != entry.getValue().getPreState()) continue;
            world.m_46597_(entry.getKey(), entry.getValue().getPostState());
            if (entry.getValue().getPostTE() != null) {
                world.m_151523_(entry.getValue().getPostTE());
            }
            if (++count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
            return false;
        }
        return true;
    }

    public Component getOperation() {
        return this.operation;
    }

    public void resetUnRedo() {
        this.iterator = null;
    }

    public boolean isDone() {
        return this.iterator == null || !this.iterator.hasNext();
    }

    public int getID() {
        return this.id;
    }

    public UUID getPlayerID() {
        return this.player;
    }
}

