/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.operations.RemoveBlockOperation;
import com.ldtteam.structurize.operations.RemoveFilteredOperation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class RemoveBlockMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final List<ItemStack> blocks;

    public RemoveBlockMessage(FriendlyByteBuf buf) {
        this.from = buf.m_130135_();
        this.to = buf.m_130135_();
        this.blocks = new ArrayList<ItemStack>();
        int blockCount = buf.readInt();
        for (int i = 0; i < blockCount; ++i) {
            this.blocks.add(buf.m_130267_());
        }
    }

    public RemoveBlockMessage(BlockPos pos1, BlockPos pos2, ItemStack stack) {
        this(pos1, pos2, List.of(stack));
    }

    public RemoveBlockMessage(BlockPos pos1, BlockPos pos2, List<ItemStack> stacks) {
        this.from = pos1;
        this.to = pos2;
        this.blocks = stacks;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.from);
        buf.m_130064_(this.to);
        buf.writeInt(this.blocks.size());
        for (ItemStack block : this.blocks) {
            buf.m_130055_(block);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().m_7500_()) {
            return;
        }
        if (this.blocks.size() > 1) {
            Manager.addToQueue(new RemoveFilteredOperation((Player)ctxIn.getSender(), this.from, this.to, this.blocks));
            return;
        }
        if (!this.blocks.isEmpty()) {
            Manager.addToQueue(new RemoveBlockOperation((Player)ctxIn.getSender(), this.from, this.to, this.blocks.get(0)));
        }
    }
}

