/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class OperationHistoryMessage
implements IMessage {
    private List<Tuple<String, Integer>> operationIDs = new ArrayList<Tuple<String, Integer>>();

    public OperationHistoryMessage(FriendlyByteBuf buf) {
        int count = buf.readInt();
        this.operationIDs = new ArrayList<Tuple<String, Integer>>();
        for (int i = 0; i < count; ++i) {
            this.operationIDs.add((Tuple<String, Integer>)new Tuple((Object)buf.m_130277_(), (Object)buf.readInt()));
        }
    }

    public OperationHistoryMessage() {
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.operationIDs.size());
        for (Tuple<String, Integer> operation : this.operationIDs) {
            buf.m_130070_((String)operation.m_14418_());
            buf.writeInt(((Integer)operation.m_14419_()).intValue());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return null;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (isLogicalServer) {
            if (ctxIn.getSender() == null) {
                return;
            }
            List<ChangeStorage> operations = Manager.getChangeStoragesForPlayer(ctxIn.getSender().m_20148_());
            this.operationIDs = new ArrayList<Tuple<String, Integer>>();
            for (ChangeStorage storage : operations) {
                this.operationIDs.add((Tuple<String, Integer>)new Tuple((Object)storage.getOperation().getString(), (Object)storage.getID()));
            }
            Network.getNetwork().sendToPlayer(this, ctxIn.getSender());
        } else {
            WindowUndoRedo.lastOperations = this.operationIDs;
        }
    }
}

