/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item;

import com.focamacho.ringsofascension.client.GlintRenderTypes;
import com.focamacho.ringsofascension.init.ModItems;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class ItemRingBase
extends Item {
    protected String tooltip;
    public final Supplier<Boolean> isEnabled;
    public final GlintRenderTypes glintType;

    public ItemRingBase(Item.Properties properties, String tooltip, Supplier<Boolean> enabled, GlintRenderTypes glintType) {
        super(properties.m_41487_(1));
        this.tooltip = tooltip;
        this.isEnabled = enabled;
        this.glintType = glintType;
        ModItems.allRings.add(this);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return super.m_7626_(stack).m_6881_().m_130940_(ChatFormatting.LIGHT_PURPLE);
    }

    public void tickCurio(String identifier, int index, LivingEntity livingEntity) {
    }

    public Multimap<Attribute, AttributeModifier> curioModifiers(ItemStack stack, String identifier) {
        return HashMultimap.create();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public void onEquippedCurio(String identifier, LivingEntity livingEntity) {
    }

    public void onUnequippedCurio(String identifier, LivingEntity livingEntity) {
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> lazyCurio = LazyOptional.of(() -> new ICurio(){

                public ItemStack getStack() {
                    return stack;
                }

                public void curioTick(SlotContext slotContext) {
                    if (!slotContext.cosmetic()) {
                        ItemRingBase.this.tickCurio(slotContext.identifier(), slotContext.index(), slotContext.entity());
                    }
                }

                @NotNull
                public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                    return new ICurio.SoundInfo(SoundEvents.f_11676_, 1.0f, 1.0f);
                }

                public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                    if (!slotContext.cosmetic()) {
                        ItemRingBase.this.onEquippedCurio(slotContext.identifier(), slotContext.entity());
                    }
                }

                @NotNull
                public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
                    return ICurio.DropRule.DEFAULT;
                }

                public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                    if (!slotContext.cosmetic()) {
                        ItemRingBase.this.onUnequippedCurio(slotContext.identifier(), slotContext.entity());
                    }
                }

                public boolean canEquipFromUse(SlotContext slotContext) {
                    return true;
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
                    return ItemRingBase.this.curioModifiers(stack, slotContext.identifier());
                }

                public List<Component> getSlotsTooltip(List<Component> tt) {
                    List tooltips = super.getAttributesTooltip(tt);
                    return ItemRingBase.replaceTooltips(tooltips);
                }

                public List<Component> getAttributesTooltip(List<Component> tt) {
                    List tooltips = super.getAttributesTooltip(tt);
                    return ItemRingBase.this.getAttributesTooltip(ItemRingBase.replaceTooltips(tooltips));
                }

                public boolean canEquip(SlotContext slotContext) {
                    return !slotContext.cosmetic();
                }
            });

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction side) {
                return CuriosCapability.ITEM.orEmpty(capability, this.lazyCurio);
            }
        };
    }

    public List<Component> getAttributesTooltip(List<Component> tt) {
        return tt;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.tooltip == null) {
            return;
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.ringsofascension.worn").getString())));
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.BLUE + Component.m_237115_((String)this.tooltip).getString())));
    }

    private static List<Component> replaceTooltips(List<Component> tooltips) {
        tooltips.replaceAll(tooltip -> ItemRingBase.changeColors(tooltip, TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD), TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)));
        return tooltips;
    }

    private static Component changeColors(Component component, TextColor from, TextColor to) {
        MutableComponent mutable = component.m_6881_();
        if (Objects.equals(mutable.m_7383_().m_131135_(), from)) {
            mutable.m_6270_(mutable.m_7383_().m_131148_(to));
        }
        mutable.m_7360_().replaceAll(component1 -> ItemRingBase.changeColors(component1, from, to));
        return mutable;
    }
}

