/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.client;

import com.focamacho.ringsofascension.client.GlintRenderType;
import com.focamacho.ringsofascension.client.GlintRenderTypes;
import com.focamacho.ringsofascension.item.ItemRingBase;
import java.util.HashMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GlintHandler {
    private static final ThreadLocal<ItemStack> stack = new ThreadLocal();
    public static final HashMap<GlintRenderTypes, RenderType> glintMap = new HashMap();
    public static final HashMap<GlintRenderTypes, RenderType> directMap = new HashMap();
    public static final HashMap<GlintRenderTypes, RenderType> translucentMap = new HashMap();

    public static void setStack(ItemStack value) {
        stack.set(value);
    }

    public static RenderType getGlintTranslucent() {
        GlintRenderTypes color = GlintHandler.getColor(stack.get());
        return color == null ? RenderType.m_110487_() : translucentMap.get((Object)color);
    }

    public static RenderType getGlint() {
        GlintRenderTypes color = GlintHandler.getColor(stack.get());
        return color == null ? RenderType.m_110490_() : glintMap.get((Object)color);
    }

    public static RenderType getGlintDirect() {
        GlintRenderTypes color = GlintHandler.getColor(stack.get());
        return color == null ? RenderType.m_110493_() : directMap.get((Object)color);
    }

    private static GlintRenderTypes getColor(ItemStack stack) {
        Item item;
        if (stack == null || !((item = stack.m_41720_()) instanceof ItemRingBase)) {
            return null;
        }
        ItemRingBase item2 = (ItemRingBase)item;
        return item2.glintType;
    }

    static {
        for (GlintRenderTypes glint : GlintRenderTypes.values()) {
            RenderType glintType = GlintRenderType.buildGlintRenderType(glint.name);
            glintMap.put(glint, glintType);
            RenderType directType = GlintRenderType.buildGlintDirectRenderType(glint.name);
            directMap.put(glint, directType);
            RenderType translucentType = GlintRenderType.buildGlintTranslucentRenderType(glint.name);
            translucentMap.put(glint, translucentType);
        }
    }
}

