/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.utils;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class VanillaLootTables {
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    private static final Set<ResourceLocation> LOOT_TABLES_READ_ONLY = Collections.unmodifiableSet(LOOT_TABLES);
    public static final ResourceLocation EMPTY = new ResourceLocation("empty");
    public static final ResourceLocation SPAWN_BONUS_CHEST = VanillaLootTables.register("chests/spawn_bonus_chest");
    public static final ResourceLocation END_CITY_TREASURE_CHEST = VanillaLootTables.register("chests/end_city_treasure");
    public static final ResourceLocation SIMPLE_DUNGEON_CHEST = VanillaLootTables.register("chests/simple_dungeon");
    public static final ResourceLocation VILLAGE_WEAPONSMITH_CHEST = VanillaLootTables.register("chests/village/village_weaponsmith");
    public static final ResourceLocation VILLAGE_TOOLSMITH_CHEST = VanillaLootTables.register("chests/village/village_toolsmith");
    public static final ResourceLocation VILLAGE_ARMORER_CHEST = VanillaLootTables.register("chests/village/village_armorer");
    public static final ResourceLocation VILLAGE_CARTOGRAPHER_CHEST = VanillaLootTables.register("chests/village/village_cartographer");
    public static final ResourceLocation VILLAGE_MASON_CHEST = VanillaLootTables.register("chests/village/village_mason");
    public static final ResourceLocation VILLAGE_SHEPARD_CHEST = VanillaLootTables.register("chests/village/village_shepherd");
    public static final ResourceLocation VILLAGE_BUTCHER_CHEST = VanillaLootTables.register("chests/village/village_butcher");
    public static final ResourceLocation VILLAGE_FLETCHER_CHEST = VanillaLootTables.register("chests/village/village_fletcher");
    public static final ResourceLocation VILLAGE_FISHER_CHEST = VanillaLootTables.register("chests/village/village_fisher");
    public static final ResourceLocation VILLAGE_TANNERY_CHEST = VanillaLootTables.register("chests/village/village_tannery");
    public static final ResourceLocation VILLAGE_TEMPLE_CHEST = VanillaLootTables.register("chests/village/village_temple");
    public static final ResourceLocation VILLAGE_DESERT_HOUSE_CHEST = VanillaLootTables.register("chests/village/village_desert_house");
    public static final ResourceLocation VILLAGE_PLAINS_CHEST = VanillaLootTables.register("chests/village/village_plains_house");
    public static final ResourceLocation VILLAGE_TAIGA_HOUSE_CHEST = VanillaLootTables.register("chests/village/village_taiga_house");
    public static final ResourceLocation VILLAGE_SNOWY_HOUSE_CHEST = VanillaLootTables.register("chests/village/village_snowy_house");
    public static final ResourceLocation VILLAGE_SAVANNA_HOUSE_CHEST = VanillaLootTables.register("chests/village/village_savanna_house");
    public static final ResourceLocation ABANDONED_MINESHAFT_CHEST = VanillaLootTables.register("chests/abandoned_mineshaft");
    public static final ResourceLocation NETHER_BRIDGE_CHEST = VanillaLootTables.register("chests/nether_bridge");
    public static final ResourceLocation STRONGHOLD_LIBRARY_CHEST = VanillaLootTables.register("chests/stronghold_library");
    public static final ResourceLocation STRONGHOLD_CROSSING_CHEST = VanillaLootTables.register("chests/stronghold_crossing");
    public static final ResourceLocation STRONGHOLD_CORRIDOR_CHEST = VanillaLootTables.register("chests/stronghold_corridor");
    public static final ResourceLocation DESERT_PYRAMID_CHEST = VanillaLootTables.register("chests/desert_pyramid");
    public static final ResourceLocation JUNGLE_TEMPLE_CHEST = VanillaLootTables.register("chests/jungle_temple");
    public static final ResourceLocation JUNGLE_TEMPLE_DISPENSER_CHEST = VanillaLootTables.register("chests/jungle_temple_dispenser");
    public static final ResourceLocation IGLOO_CHEST_CHEST = VanillaLootTables.register("chests/igloo_chest");
    public static final ResourceLocation WOODLAND_MANSION_CHEST = VanillaLootTables.register("chests/woodland_mansion");
    public static final ResourceLocation UNDERWATER_RUIN_SMALL_CHEST = VanillaLootTables.register("chests/underwater_ruin_small");
    public static final ResourceLocation UNDERWATER_RUIN_BIG_CHEST = VanillaLootTables.register("chests/underwater_ruin_big");
    public static final ResourceLocation BURIED_TREASURE_CHEST = VanillaLootTables.register("chests/buried_treasure");
    public static final ResourceLocation SHIPWRECK_MAP_CHEST = VanillaLootTables.register("chests/shipwreck_map");
    public static final ResourceLocation SHIPWRECK_SUPPLY_CHEST = VanillaLootTables.register("chests/shipwreck_supply");
    public static final ResourceLocation SHIPWRECK_TREASURE_CHEST = VanillaLootTables.register("chests/shipwreck_treasure");
    public static final ResourceLocation PILLAGER_OUTPOST_CHEST = VanillaLootTables.register("chests/pillager_outpost");
    public static final ResourceLocation BASTION_TREASURE_CHEST = VanillaLootTables.register("chests/bastion_treasure");
    public static final ResourceLocation BASTION_OTHER_CHEST = VanillaLootTables.register("chests/bastion_other");
    public static final ResourceLocation BASTION_BRIDGE_CHEST = VanillaLootTables.register("chests/bastion_bridge");
    public static final ResourceLocation BASTION_HOGLIN_STABLE_CHEST = VanillaLootTables.register("chests/bastion_hoglin_stable");
    public static final ResourceLocation ANCIENT_CITY_CHEST = VanillaLootTables.register("chests/ancient_city");
    public static final ResourceLocation ANCIENT_CITY_ICE_BOX_CHEST = VanillaLootTables.register("chests/ancient_city_ice_box");
    public static final ResourceLocation RUINED_PORTAL_CHEST = VanillaLootTables.register("chests/ruined_portal");
    public static final ResourceLocation WHITE_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/white");
    public static final ResourceLocation ORANGE_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/orange");
    public static final ResourceLocation MAGENTA_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/magenta");
    public static final ResourceLocation LIGHT_BLUE_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/light_blue");
    public static final ResourceLocation YELLOW_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/yellow");
    public static final ResourceLocation LIME_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/lime");
    public static final ResourceLocation PINK_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/pink");
    public static final ResourceLocation GRAY_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/gray");
    public static final ResourceLocation LIGHT_GRAY_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/light_gray");
    public static final ResourceLocation CYAN_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/cyan");
    public static final ResourceLocation PURPLE_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/purple");
    public static final ResourceLocation BLUE_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/blue");
    public static final ResourceLocation BROWN_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/brown");
    public static final ResourceLocation GREEN_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/green");
    public static final ResourceLocation RED_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/red");
    public static final ResourceLocation BLACK_SHEEP_ENTITY = VanillaLootTables.register("entities/sheep/black");
    public static final ResourceLocation FISHING_GAMEPLAY = VanillaLootTables.register("gameplay/fishing");
    public static final ResourceLocation FISHING_JUNK_GAMEPLAY = VanillaLootTables.register("gameplay/fishing/junk");
    public static final ResourceLocation FISHING_TREASURE_GAMEPLAY = VanillaLootTables.register("gameplay/fishing/treasure");
    public static final ResourceLocation FISHING_FISH_GAMEPLAY = VanillaLootTables.register("gameplay/fishing/fish");
    public static final ResourceLocation CAT_MORNING_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/cat_morning_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_ARMORER_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/armorer_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_BUTCHER_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/butcher_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_CARTOGRAPHER_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/cartographer_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_CLERIC_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/cleric_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_FARMER_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/farmer_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_FISHERMAN_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/fisherman_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_FLETCHER_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/fletcher_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_LEATHERWORKER_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/leatherworker_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_LIBRARIAN_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/librarian_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_MASON_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/mason_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_SHEPHERD_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/shepherd_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_TOOLSMITH_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/toolsmith_gift");
    public static final ResourceLocation HERO_OF_THE_VILLAGE_WEAPONSMITH_GIFT_GAMEPLAY = VanillaLootTables.register("gameplay/hero_of_the_village/weaponsmith_gift");
    public static final ResourceLocation SNIFFER_DIGGING_GAMEPLAY = VanillaLootTables.register("gameplay/sniffer_digging");
    public static final ResourceLocation PIGLIN_BARTERING_GAMEPLAY = VanillaLootTables.register("gameplay/piglin_bartering");
    public static final ResourceLocation DESERT_WELL_ARCHAEOLOGY = VanillaLootTables.register("archaeology/desert_well");
    public static final ResourceLocation DESERT_PYRAMID_ARCHAEOLOGY = VanillaLootTables.register("archaeology/desert_pyramid");
    public static final ResourceLocation TRAIL_RUINS_COMMON_ARCHAEOLOGY = VanillaLootTables.register("archaeology/trail_ruins_common");
    public static final ResourceLocation TRAIL_RUINS_RARE_ARCHAEOLOGY = VanillaLootTables.register("archaeology/trail_ruins_rare");
    public static final ResourceLocation OCEAN_RUIN_WARM_ARCHAEOLOGY = VanillaLootTables.register("archaeology/ocean_ruin_warm");
    public static final ResourceLocation OCEAN_RUIN_COLD_ARCHAEOLOGY = VanillaLootTables.register("archaeology/ocean_ruin_cold");

    private static ResourceLocation register(String id) {
        return VanillaLootTables.registerLootTable(new ResourceLocation(id));
    }

    private static ResourceLocation registerLootTable(ResourceLocation id) {
        if (LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(id + " is already a registered built-in loot table");
    }

    public static Set<ResourceLocation> getAll() {
        return LOOT_TABLES_READ_ONLY;
    }
}

