/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.mixin;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.world.biome.EndDataCompat;
import net.lyof.phantasm.world.biome.ModBiomes;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Climate.ParameterList.class}, priority=1100)
public abstract class ClimateParameterListMixin<T> {
    @Unique
    private final List<Pair<Climate.ParameterPoint, T>> endEntries = new ArrayList<Pair<Climate.ParameterPoint, T>>();

    @Shadow
    public abstract List<Pair<Climate.ParameterPoint, T>> m_186850_();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Climate$RTree;create(Ljava/util/List;)Lnet/minecraft/world/level/biome/Climate$RTree;"))
    public Climate.RTree<T> addEndBiomes(List<Pair<Climate.ParameterPoint, T>> entries) {
        Climate.ParameterPoint highlands = null;
        for (Pair<Climate.ParameterPoint, T> e : entries) {
            Holder r;
            Object object = e.getSecond();
            if (!(object instanceof Holder) || !(r = (Holder)object).m_203565_(Biomes.f_48164_)) continue;
            highlands = (Climate.ParameterPoint)e.getFirst();
        }
        if (highlands != null && ModBiomes.LOOKUP != null) {
            int customCount = EndDataCompat.getEnabledBiomes().size();
            int j = 0;
            for (ResourceKey resourceKey : EndDataCompat.getEnabledBiomes()) {
                Phantasm.log("Adding " + resourceKey.m_135782_() + " to the End biome source at slice " + (j / 2 + 1) + " out of " + customCount);
                this.endEntries.add(new Pair((Object)ClimateParameterListMixin.splitHypercube(highlands, customCount, j), (Object)ModBiomes.LOOKUP.m_255043_(resourceKey)));
                j += 2;
            }
            this.endEntries.addAll(entries.stream().filter(p -> {
                Holder k;
                Object patt2687$temp;
                Holder r;
                Object patt2582$temp = p.getSecond();
                return patt2582$temp instanceof Holder && !(r = (Holder)patt2582$temp).m_203565_(Biomes.f_48164_) && (!((patt2687$temp = r.m_203543_().get()) instanceof Holder) || !EndDataCompat.contains((Holder<Biome>)(k = (Holder)patt2687$temp)));
            }).toList());
            for (int i = 1; i <= customCount; i += 2) {
                this.endEntries.add(new Pair((Object)ClimateParameterListMixin.splitHypercube(highlands, customCount, i), (Object)ModBiomes.LOOKUP.m_255043_(Biomes.f_48164_)));
            }
            return Climate.RTree.m_186935_(this.endEntries);
        }
        return Climate.RTree.m_186935_(entries);
    }

    @Unique
    private static Climate.ParameterPoint splitHypercube(Climate.ParameterPoint base, int biomes, int i) {
        biomes = biomes * 2 - 1;
        if (EndDataCompat.getCompatibilityMode().equals("endercon")) {
            return Climate.m_186798_((Climate.Parameter)ClimateParameterListMixin.splitRange(base.f_186863_(), biomes, i), (Climate.Parameter)base.f_186864_(), (Climate.Parameter)base.f_186865_(), (Climate.Parameter)base.f_186866_(), (Climate.Parameter)base.f_186867_(), (Climate.Parameter)base.f_186868_(), (float)((float)base.f_186869_() / 10000.0f));
        }
        if (EndDataCompat.getCompatibilityMode().equals("nullscape")) {
            return Climate.m_186798_((Climate.Parameter)base.f_186863_(), (Climate.Parameter)base.f_186864_(), (Climate.Parameter)base.f_186865_(), (Climate.Parameter)base.f_186866_(), (Climate.Parameter)base.f_186867_(), (Climate.Parameter)ClimateParameterListMixin.splitRange(base.f_186868_(), biomes, i), (float)((float)base.f_186869_() / 10000.0f));
        }
        return Climate.m_186798_((Climate.Parameter)base.f_186863_(), (Climate.Parameter)base.f_186864_(), (Climate.Parameter)ClimateParameterListMixin.splitRange(base.f_186865_(), biomes, i), (Climate.Parameter)base.f_186866_(), (Climate.Parameter)base.f_186867_(), (Climate.Parameter)base.f_186868_(), (float)((float)base.f_186869_() / 10000.0f));
    }

    @Unique
    private static Climate.Parameter splitRange(Climate.Parameter point, int biomes, int i) {
        long min = ClimateParameterListMixin.getRange(point) / (long)biomes * (long)i + point.f_186813_();
        long max = ClimateParameterListMixin.getRange(point) / (long)biomes * (long)(i + 1) + point.f_186813_();
        return Climate.Parameter.m_186822_((float)((float)min / 10000.0f), (float)((float)max / 10000.0f));
    }

    @Unique
    private static long getRange(Climate.Parameter point) {
        return point.f_186814_() - point.f_186813_();
    }

    @ModifyArg(method={"<init>"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Climate$RTree;create(Ljava/util/List;)Lnet/minecraft/world/level/biome/Climate$RTree;"))
    public List<Pair<Climate.ParameterPoint, T>> modifyTree(List<Pair<Climate.ParameterPoint, T>> entries) {
        return this.m_186850_();
    }

    @Inject(method={"values"}, at={@At(value="HEAD")}, cancellable=true)
    public void redirectEntries(CallbackInfoReturnable<List<Pair<Climate.ParameterPoint, T>>> cir) {
        if (!this.endEntries.isEmpty()) {
            cir.setReturnValue(this.endEntries);
        }
    }
}

