/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.lyof.phantasm.block.custom.CrystalShardBlock;
import net.lyof.phantasm.block.custom.DirectionalBlock;
import net.lyof.phantasm.block.custom.DragonMintBlock;
import net.lyof.phantasm.block.custom.HangingFruitBlock;
import net.lyof.phantasm.block.custom.HangingPlantBlock;
import net.lyof.phantasm.block.custom.ModRotatedPillarBlock;
import net.lyof.phantasm.block.custom.NihiliumBlock;
import net.lyof.phantasm.block.custom.PillaringPlantBlock;
import net.lyof.phantasm.block.custom.PomeBlock;
import net.lyof.phantasm.block.custom.SubwooferBlock;
import net.lyof.phantasm.block.custom.signs.ModHangingSignBlock;
import net.lyof.phantasm.block.custom.signs.ModStandingSignBlock;
import net.lyof.phantasm.block.custom.signs.ModWallHangingSignBlock;
import net.lyof.phantasm.block.custom.signs.ModWallSignBlock;
import net.lyof.phantasm.effect.ModEffects;
import net.lyof.phantasm.item.ModItems;
import net.lyof.phantasm.setup.ModTags;
import net.lyof.phantasm.world.feature.tree.PreamSaplingGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"phantasm");
    private static final BlockBehaviour.Properties CrystalMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60953_(blockState -> 4).m_60991_((a, b, c) -> true).m_60955_();
    private static final BlockBehaviour.Properties CrystalGlassMaterial = BlockBehaviour.Properties.m_284310_().m_60991_((a, b, c) -> true).m_60978_(0.75f).m_60953_(blockState -> 4).m_60955_().m_284180_(MapColor.f_283869_).m_60918_(SoundType.f_56744_);
    private static final BlockBehaviour.Properties PolishedObsidianMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50080_).m_60978_(7.0f);
    private static final BlockBehaviour.Properties PreamWoodMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_284180_(MapColor.f_283748_);
    private static final BlockBehaviour.Properties PreamPlankMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_284180_(MapColor.f_283843_);
    private static final BlockBehaviour.Properties PreamPassableMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_).m_284180_(MapColor.f_283843_);
    private static final BlockBehaviour.Properties PreamLeafMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_284180_(MapColor.f_283892_);
    private static final BlockBehaviour.Properties RawPurpurMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50730_).m_284180_(MapColor.f_283892_);
    private static final BlockBehaviour.Properties OblivionMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152544_).m_284180_(MapColor.f_283927_);
    private static final BlockBehaviour.Properties acidicMassMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152544_).m_284180_(MapColor.f_283807_).m_60978_(1.8f);
    private static final BlockBehaviour.Properties pomeMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50186_).m_284180_(MapColor.f_283807_).m_60978_(1.5f);
    private static final BlockBehaviour.Properties ciriteMaterial = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_).m_284180_(MapColor.f_283807_).m_60913_(2.0f, 0.2f).m_60911_(1.0f);
    public static List<RegistryObject<Block>> BLOCK_CUTOUT = new ArrayList<RegistryObject<Block>>();
    public static List<RegistryObject<Block>> BLOCK_TRANSLUCENT = new ArrayList<RegistryObject<Block>>();
    public static final WoodType PREAM = new WoodType("pream", BlockSetType.f_271198_);
    public static final RegistryObject<Block> FALLEN_STAR = ModBlocks.registerBlock("fallen_star", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_284180_(MapColor.f_283869_).m_60953_(blockState -> 15)));
    public static final RegistryObject<Block> POLISHED_OBSIDIAN = ModBlocks.registerBlock("polished_obsidian", () -> new Block(PolishedObsidianMaterial));
    public static final RegistryObject<Block> POLISHED_OBSIDIAN_BRICKS = ModBlocks.registerBlock("polished_obsidian_bricks", () -> new Block(PolishedObsidianMaterial));
    public static final RegistryObject<Block> POLISHED_OBSIDIAN_BRICKS_STAIRS = ModBlocks.registerBlock("polished_obsidian_bricks_stairs", () -> new StairBlock(() -> ((Block)POLISHED_OBSIDIAN_BRICKS.get()).m_49966_(), PolishedObsidianMaterial), BLOCK_CUTOUT);
    public static final RegistryObject<Block> POLISHED_OBSIDIAN_BRICKS_SLAB = ModBlocks.registerBlock("polished_obsidian_bricks_slab", () -> new SlabBlock(PolishedObsidianMaterial), BLOCK_CUTOUT);
    public static final RegistryObject<Block> CRYSTAL_SHARD = ModBlocks.registerBlock("crystal_shard", () -> new CrystalShardBlock(CrystalMaterial.m_60953_(b -> 7).m_60918_(SoundType.f_56744_)), BLOCK_CUTOUT);
    public static final RegistryObject<Block> VOID_CRYSTAL_SHARD = ModBlocks.registerBlock("void_crystal_shard", () -> new CrystalShardBlock(CrystalMaterial), BLOCK_CUTOUT);
    public static final RegistryObject<Block> CRYSTAL_BLOCK = ModBlocks.registerBlock("crystal_block", () -> new Block(CrystalMaterial));
    public static final RegistryObject<Block> CRYSTAL_TILES = ModBlocks.registerBlock("crystal_tiles", () -> new Block(CrystalMaterial));
    public static final RegistryObject<Block> CRYSTAL_TILES_STAIRS = ModBlocks.registerBlock("crystal_tiles_stairs", () -> new StairBlock(() -> ((Block)CRYSTAL_TILES.get()).m_49966_(), CrystalMaterial), BLOCK_CUTOUT);
    public static final RegistryObject<Block> CRYSTAL_TILES_SLAB = ModBlocks.registerBlock("crystal_tiles_slab", () -> new SlabBlock(CrystalMaterial), BLOCK_CUTOUT);
    public static final RegistryObject<Block> CRYSTAL_PILLAR = ModBlocks.registerBlock("crystal_pillar", () -> new RotatedPillarBlock(CrystalMaterial));
    public static final RegistryObject<Block> CRYSTAL_GLASS = ModBlocks.registerBlock("crystal_glass", () -> new Block(CrystalGlassMaterial.m_60955_()), BLOCK_CUTOUT);
    public static final RegistryObject<Block> CRYSTAL_GLASS_PANE = ModBlocks.registerBlock("crystal_glass_pane", () -> new StainedGlassPaneBlock(DyeColor.BLUE, CrystalGlassMaterial.m_60955_()), BLOCK_CUTOUT);
    public static final RegistryObject<Block> VOID_CRYSTAL_BLOCK = ModBlocks.registerBlock("void_crystal_block", () -> new Block(CrystalMaterial));
    public static final RegistryObject<Block> VOID_CRYSTAL_TILES = ModBlocks.registerBlock("void_crystal_tiles", () -> new Block(CrystalMaterial));
    public static final RegistryObject<Block> VOID_CRYSTAL_TILES_STAIRS = ModBlocks.registerBlock("void_crystal_tiles_stairs", () -> new StairBlock(() -> ((Block)VOID_CRYSTAL_TILES.get()).m_49966_(), CrystalGlassMaterial), BLOCK_CUTOUT);
    public static final RegistryObject<Block> VOID_CRYSTAL_TILES_SLAB = ModBlocks.registerBlock("void_crystal_tiles_slab", () -> new SlabBlock(CrystalMaterial), BLOCK_CUTOUT);
    public static final RegistryObject<Block> VOID_CRYSTAL_PILLAR = ModBlocks.registerBlock("void_crystal_pillar", () -> new RotatedPillarBlock(CrystalGlassMaterial));
    public static final RegistryObject<Block> VOID_CRYSTAL_GLASS = ModBlocks.registerBlock("void_crystal_glass", () -> new Block(CrystalGlassMaterial.m_60955_()), BLOCK_CUTOUT);
    public static final RegistryObject<Block> VOID_CRYSTAL_GLASS_PANE = ModBlocks.registerBlock("void_crystal_glass_pane", () -> new StainedGlassPaneBlock(DyeColor.BLUE, CrystalGlassMaterial.m_60955_()), BLOCK_CUTOUT);
    public static final RegistryObject<Block> STRIPPED_PREAM_LOG = ModBlocks.log("stripped_pream_log", MapColor.f_283869_, MapColor.f_283743_, PreamWoodMaterial);
    public static final RegistryObject<Block> PREAM_LOG = ModBlocks.log("pream_log", MapColor.f_283869_, MapColor.f_283743_, PreamWoodMaterial);
    public static final RegistryObject<Block> STRIPPED_PREAM_WOOD = ModBlocks.log("stripped_pream_wood", MapColor.f_283869_, MapColor.f_283743_, PreamWoodMaterial);
    public static final RegistryObject<Block> PREAM_WOOD = ModBlocks.log("pream_wood", MapColor.f_283869_, MapColor.f_283743_, PreamWoodMaterial);
    public static final RegistryObject<Block> PREAM_LEAVES = ModBlocks.registerBlock("pream_leaves", () -> new LeavesBlock(PreamLeafMaterial), BLOCK_CUTOUT);
    public static final RegistryObject<Block> HANGING_PREAM_LEAVES = ModBlocks.registerBlock("hanging_pream_leaves", () -> new HangingFruitBlock(PreamLeafMaterial.m_60910_(), ModTags.Blocks.HANGING_PREAM_LEAVES_GROWABLE_ON, Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), "pream_berry"), BLOCK_CUTOUT);
    public static final RegistryObject<Block> PREAM_PLANKS = ModBlocks.registerBlock("pream_planks", () -> new Block(PreamPlankMaterial));
    public static final RegistryObject<Block> PREAM_STAIRS = ModBlocks.registerBlock("pream_stairs", () -> new StairBlock(() -> ((Block)PREAM_PLANKS.get()).m_49966_(), PreamPlankMaterial));
    public static final RegistryObject<Block> PREAM_SLAB = ModBlocks.registerBlock("pream_slab", () -> new SlabBlock(PreamPlankMaterial));
    public static final RegistryObject<Block> PREAM_PRESSURE_PLATE = ModBlocks.registerBlock("pream_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, PreamPassableMaterial, PREAM.f_271340_()));
    public static final RegistryObject<Block> PREAM_BUTTON = ModBlocks.registerBlock("pream_button", () -> new ButtonBlock(PreamPassableMaterial, PREAM.f_271340_(), 10, true));
    public static final RegistryObject<Block> PREAM_FENCE = ModBlocks.registerBlock("pream_fence", () -> new FenceBlock(PreamPlankMaterial));
    public static final RegistryObject<Block> PREAM_FENCE_GATE = ModBlocks.registerBlock("pream_fence_gate", () -> new FenceGateBlock(PreamPlankMaterial, PREAM));
    public static final RegistryObject<Block> PREAM_DOOR = ModBlocks.registerBlock("pream_door", () -> new DoorBlock(PreamPlankMaterial.m_60955_(), PREAM.f_271340_()), BLOCK_CUTOUT);
    public static final RegistryObject<Block> PREAM_TRAPDOOR = ModBlocks.registerBlock("pream_trapdoor", () -> new TrapDoorBlock(PreamPlankMaterial.m_60955_(), PREAM.f_271340_()), BLOCK_CUTOUT);
    public static final RegistryObject<Block> PREAM_SIGN = BLOCKS.register("pream_sign", () -> new ModStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_), WoodType.f_61830_));
    public static final RegistryObject<Block> PREAM_WALL_SIGN = BLOCKS.register("pream_wall_sign", () -> new ModWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50158_), WoodType.f_61830_));
    public static final RegistryObject<Block> PREAM_HANGING_SIGN = BLOCKS.register("pream_hanging_sign", () -> new ModHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_), WoodType.f_61830_));
    public static final RegistryObject<Block> PREAM_WALL_HANGING_SIGN = BLOCKS.register("pream_wall_hanging_sign", () -> new ModWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244093_), WoodType.f_61830_));
    public static final RegistryObject<Block> PREAM_SAPLING = ModBlocks.registerBlock("pream_sapling", () -> new SaplingBlock(new PreamSaplingGenerator(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)){

        public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
            return reader.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || reader.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final RegistryObject<Block> OBLIVINE = ModBlocks.registerBlock("oblivine", () -> new HangingFruitBlock(OblivionMaterial.m_60966_().m_60910_(), ModTags.Blocks.OBLIVINE_GROWABLE_ON, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), "oblifruit"), BLOCK_CUTOUT);
    public static final RegistryObject<Block> OBLIVION = ModBlocks.registerBlock("oblivion", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_).m_284180_(MapColor.f_283927_)), BLOCK_CUTOUT);
    public static final RegistryObject<Block> CRYSTALILY = ModBlocks.registerBlock("crystalily", () -> new HangingPlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_).m_284180_(MapColor.f_283869_).m_60966_().m_60955_().m_60953_(blockState -> 7).m_60991_((bs, br, bp) -> true), ModTags.Blocks.OBLIVINE_GROWABLE_ON, Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), BLOCK_CUTOUT);
    public static final RegistryObject<Block> VIVID_NIHILIUM = ModBlocks.registerBlock("vivid_nihilium", () -> new NihiliumBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50259_).m_284180_(MapColor.f_283772_).m_60977_()), BLOCK_CUTOUT);
    public static final RegistryObject<Block> VIVID_NIHILIS = ModBlocks.registerBlock("vivid_nihilis", () -> new BushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50693_).m_284180_(MapColor.f_283772_)){

        public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
            return reader.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || reader.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final RegistryObject<Block> STARFLOWER = ModBlocks.registerBlock("starflower", () -> new FlowerBlock(() -> MobEffects.f_19611_, 100, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50693_).m_284180_(MapColor.f_283869_).m_60966_().m_60910_().m_60955_().m_60953_(state -> 5).m_60991_((a, b, c) -> true)){

        public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
            return reader.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final RegistryObject<Block> TALL_VIVID_NIHILIS = ModBlocks.registerOnlyBlock("tall_vivid_nihilis", () -> new DoublePlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50035_).m_284180_(MapColor.f_283772_)){

        public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
            return state.m_61143_((Property)DoublePlantBlock.f_52858_) != DoubleBlockHalf.LOWER || reader.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || reader.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final RegistryObject<Block> ACIDIC_NIHILIUM = ModBlocks.registerBlock("acidic_nihilium", () -> new NihiliumBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50259_).m_284180_(MapColor.f_283745_).m_60977_()), BLOCK_CUTOUT);
    public static final RegistryObject<Block> ACIDIC_NIHILIS = ModBlocks.registerBlock("acidic_nihilis", () -> new BushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50693_).m_284180_(MapColor.f_283745_)){

        public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
            return reader.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || reader.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final RegistryObject<Block> TALL_ACIDIC_NIHILIS = ModBlocks.registerOnlyBlock("tall_acidic_nihilis", () -> new DoublePlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50035_).m_284180_(MapColor.f_283772_)){

        public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
            return state.m_61143_((Property)DoublePlantBlock.f_52858_) != DoubleBlockHalf.LOWER || reader.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || reader.m_8055_(pos.m_7495_()).m_204336_(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }
    }, BLOCK_CUTOUT);
    public static final RegistryObject<Block> DRAGON_MINT = ModBlocks.registerBlock("dragon_mint", () -> new DragonMintBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50693_).m_60977_().m_284180_(MapColor.f_283804_).m_60918_(SoundType.f_271239_).m_222979_(BlockBehaviour.OffsetType.NONE).m_60953_(state -> (Boolean)state.m_61143_((Property)HangingFruitBlock.HAS_FRUIT) != false ? 9 : 0)), BLOCK_CUTOUT);
    public static final RegistryObject<Block> ACIDIC_MASS = ModBlocks.registerBlock("acidic_mass", () -> new Block(acidicMassMaterial){

        public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
            if (!entity.m_20161_()) {
                entity.m_20256_(entity.m_20184_().m_82542_(0.4, 1.0, 0.4));
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.m_7292_(new MobEffectInstance((MobEffect)ModEffects.CORROSION.get(), 100, 0));
                }
            }
            super.m_141947_(level, pos, state, entity);
        }
    });
    public static final RegistryObject<Block> DRALGAE = ModBlocks.registerBlock("dralgae", () -> new PillaringPlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50693_).m_284180_(MapColor.f_283883_).m_222979_(BlockBehaviour.OffsetType.NONE), ModTags.Blocks.DRALGAE_GROWABLE_ON, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)), BLOCK_CUTOUT);
    public static final RegistryObject<Block> POME = ModBlocks.registerBlock("pome", () -> new PomeBlock(pomeMaterial));
    public static final RegistryObject<Block> RAW_PURPUR = ModBlocks.registerBlock("raw_purpur", () -> new Block(RawPurpurMaterial));
    public static final RegistryObject<Block> RAW_PURPUR_BRICKS = ModBlocks.registerBlock("raw_purpur_bricks", () -> new Block(RawPurpurMaterial));
    public static final RegistryObject<Block> RAW_PURPUR_BRICKS_STAIRS = ModBlocks.registerBlock("raw_purpur_bricks_stairs", () -> new StairBlock(() -> ((Block)RAW_PURPUR_BRICKS.get()).m_49966_(), RawPurpurMaterial));
    public static final RegistryObject<Block> RAW_PURPUR_BRICKS_SLAB = ModBlocks.registerBlock("raw_purpur_bricks_slab", () -> new SlabBlock(RawPurpurMaterial));
    public static final RegistryObject<Block> RAW_PURPUR_TILES = ModBlocks.registerBlock("raw_purpur_tiles", () -> new Block(RawPurpurMaterial));
    public static final RegistryObject<Block> RAW_PURPUR_PILLAR = ModBlocks.registerBlock("raw_purpur_pillar", () -> new RotatedPillarBlock(RawPurpurMaterial));
    public static final RegistryObject<Block> PURPUR_LAMP = ModBlocks.registerBlock("purpur_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50492_).m_60953_(block -> 15)));
    public static final RegistryObject<Block> CIRITE = ModBlocks.registerBlock("cirite", () -> new Block(ciriteMaterial));
    public static final RegistryObject<Block> CIRITE_IRON_ORE = ModBlocks.registerBlock("cirite_iron_ore", () -> new Block(ciriteMaterial));
    public static final RegistryObject<Block> CIRITE_BRICKS = ModBlocks.registerBlock("cirite_bricks", () -> new Block(ciriteMaterial));
    public static final RegistryObject<Block> CIRITE_BRICKS_STAIRS = ModBlocks.registerBlock("cirite_bricks_stairs", () -> new StairBlock(() -> ((Block)CIRITE_BRICKS.get()).m_49966_(), ciriteMaterial));
    public static final RegistryObject<Block> CIRITE_BRICKS_SLAB = ModBlocks.registerBlock("cirite_bricks_slab", () -> new SlabBlock(ciriteMaterial));
    public static final RegistryObject<Block> CHORAL_BLOCK = ModBlocks.registerBlock("choral_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50585_).m_284180_(MapColor.f_283919_)));
    public static final RegistryObject<Block> CHORAL_FAN = ModBlocks.registerBlock("choral_fan", () -> new DirectionalBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50553_).m_284180_(MapColor.f_283919_)), BLOCK_CUTOUT);
    public static final RegistryObject<Block> SUBWOOFER_BLOCK = ModBlocks.registerBlock("subwoofer_block", () -> new SubwooferBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50065_).m_284180_(MapColor.f_283919_)));

    private static RegistryObject<Block> log(String name, MapColor color, MapColor color1, BlockBehaviour.Properties properties) {
        return ModBlocks.registerBlock(name, () -> new ModRotatedPillarBlock(properties.m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? color : color1)));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerOnlyBlock(String name, Supplier<T> block, List<RegistryObject<T>> addTo) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        addTo.add(toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, List<RegistryObject<T>> addTo) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        addTo.add(toReturn);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

