/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.wood;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.PottedBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit.BWGFruitBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.grower.BWGTreeGrowers;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves.BWGChangingLeavesBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves.BWGFireCrackerLeaves;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves.BWGFruitLeavesBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves.BWGLeavesBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.sapling.BWGSaplingBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;
import net.potionstudios.biomeswevegone.world.level.block.wood.ImbuedBlock;

public class BWGWood {
    public static final ArrayList<Supplier<? extends Block>> WOOD = new ArrayList();
    public static final ArrayList<Supplier<? extends Item>> WOOD_BLOCK_ITEMS = new ArrayList();
    public static final ArrayList<Supplier<? extends Block>> NONSET_WOOD = new ArrayList();
    public static final BWGWoodSet ASPEN = new BWGWoodSet("aspen", MapColor.f_283942_, BWGTreeGrowers.ASPEN);
    public static final BWGWoodSet BAOBAB = new BWGWoodSet("baobab", MapColor.f_283919_, BWGTreeGrowers.BAOBAB);
    public static final BWGWoodSet BLUE_ENCHANTED = new BWGWoodSet("blue_enchanted", MapColor.f_283743_, BWGTreeGrowers.BLUE_ENCHANTED, true);
    public static final Supplier<ImbuedBlock> IMBUED_BLUE_ENCHANTED_WOOD = BWGWood.registerBlockItem("imbued_blue_enchanted_wood", () -> new ImbuedBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283743_)));
    public static final BWGWoodSet CIKA = new BWGWoodSet("cika", MapColor.f_283919_, BWGTreeGrowers.CIKA);
    public static final BWGWoodSet CYPRESS = new BWGWoodSet("cypress", MapColor.f_283919_, BWGTreeGrowers.CYPRESS);
    public static final BWGWoodSet EBONY = new BWGWoodSet("ebony", MapColor.f_283927_, BWGTreeGrowers.EBONY);
    public static final BWGWoodSet FIR = new BWGWoodSet("fir", MapColor.f_283919_, BWGTreeGrowers.FIR);
    public static final BWGWoodSet FLORUS = new BWGWoodSet(new BlockSetType("florus"), MapColor.f_283784_, BWGWoodSet.LogStem.STEM, null, false, false, null);
    public static final BWGWoodSet GREEN_ENCHANTED = new BWGWoodSet("green_enchanted", MapColor.f_283916_, BWGTreeGrowers.GREEN_ENCHANTED, true);
    public static final Supplier<ImbuedBlock> IMBUED_GREEN_ENCHANTED_WOOD = BWGWood.registerBlockItem("imbued_green_enchanted_wood", () -> new ImbuedBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283916_)));
    public static final BWGWoodSet HOLLY = new BWGWoodSet("holly", MapColor.f_283919_, BWGTreeGrowers.HOLLY);
    public static final BWGWoodSet IRONWOOD = new BWGWoodSet("ironwood", MapColor.f_283818_, BWGTreeGrowers.IRONWOOD);
    public static final BWGWoodSet JACARANDA = new BWGWoodSet("jacaranda", MapColor.f_283765_, BWGTreeGrowers.JACARANDA);
    public static final BWGWoodSet MAHOGANY = new BWGWoodSet("mahogany", MapColor.f_283765_, BWGTreeGrowers.MAHOGANY);
    public static final BWGWoodSet MAPLE = new BWGWoodSet("maple", MapColor.f_283919_, BWGTreeGrowers.MAPLE);
    public static final BWGWoodSet PALM = new BWGWoodSet("palm", MapColor.f_283919_, BWGTreeGrowers.PALM, (TagKey<Block>)BlockTags.f_13029_);
    public static final BWGWoodSet PINE = new BWGWoodSet("pine", MapColor.f_283919_, BWGTreeGrowers.PINE);
    public static final BWGWoodSet RAINBOW_EUCALYPTUS = new BWGWoodSet("rainbow_eucalyptus", MapColor.f_283919_, BWGTreeGrowers.RAINBOW_EUCALYPTUS);
    public static final BWGWoodSet REDWOOD = new BWGWoodSet("redwood", MapColor.f_283913_, BWGTreeGrowers.REDWOOD);
    public static final BWGWoodSet SAKURA = new BWGWoodSet(BlockSetType.m_272115_((BlockSetType)new BlockSetType("sakura", true, SoundType.f_271497_, SoundEvents.f_271488_, SoundEvents.f_271095_, SoundEvents.f_271262_, SoundEvents.f_271395_, SoundEvents.f_271444_, SoundEvents.f_271406_, SoundEvents.f_271322_, SoundEvents.f_271171_)), MapColor.f_283913_, null, false);
    public static final PottedBlock WHITE_SAKURA_SAPLING = BWGWood.createSapling("white_sakura", BWGTreeGrowers.WHITE_SAKURA, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock YELLOW_SAKURA_SAPLING = BWGWood.createSapling("yellow_sakura", BWGTreeGrowers.YELLOW_SAKURA, (TagKey<Block>)BlockTags.f_144274_);
    public static final BWGWoodSet SKYRIS = new BWGWoodSet("skyris", MapColor.f_283869_, BWGTreeGrowers.SKYRIS);
    public static final BWGWoodSet WHITE_MANGROVE = new BWGWoodSet("white_mangrove", MapColor.f_283919_, BWGTreeGrowers.WHITE_MANGROVE);
    public static final BWGWoodSet WILLOW = new BWGWoodSet("willow", MapColor.f_283784_, BWGTreeGrowers.WILLOW);
    public static final BWGWoodSet WITCH_HAZEL = new BWGWoodSet("witch_hazel", MapColor.f_283784_, BWGTreeGrowers.WITCH_HAZEL);
    public static final BWGWoodSet ZELKOVA = new BWGWoodSet("zelkova", MapColor.f_283750_, BWGTreeGrowers.ZELKOVA);
    public static final Supplier<RotatedPillarBlock> PALO_VERDE_LOG = BWGWood.registerBlockItem("palo_verde_log", () -> Blocks.m_284204_((MapColor)MapColor.f_283784_, (MapColor)MapColor.f_283784_));
    public static final Supplier<RotatedPillarBlock> PALO_VERDE_WOOD = BWGWood.registerBlockItem("palo_verde_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_()));
    public static final Supplier<RotatedPillarBlock> STRIPPED_PALO_VERDE_LOG = BWGWood.registerBlockItem("stripped_palo_verde_log", () -> Blocks.m_284204_((MapColor)MapColor.f_283784_, (MapColor)MapColor.f_283784_));
    public static final Supplier<RotatedPillarBlock> STRIPPED_PALO_VERDE_WOOD = BWGWood.registerBlockItem("stripped_palo_verde_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_()));
    public static final Supplier<LeavesBlock> PALO_VERDE_LEAVES = BWGWood.registerBlockItem("palo_verde_leaves", () -> Blocks.m_152614_((SoundType)SoundType.f_56740_));
    public static final PottedBlock PALO_VERDE_SAPLING = BWGWood.createSapling("palo_verde", BWGTreeGrowers.PALO_VERDE, (TagKey<Block>)BlockTags.f_13029_);
    public static final PottedBlock ARAUCARIA_SAPLING = BWGWood.createNonSetSapling("araucaria", BWGTreeGrowers.ARAUCARIA, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock BLUE_SPRUCE_SAPLING = BWGWood.createNonSetSapling("blue_spruce", BWGTreeGrowers.BLUE_SPRUCE, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock BROWN_BIRCH_SAPLING = BWGWood.createNonSetSapling("brown_birch", BWGTreeGrowers.BROWN_BIRCH, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock BROWN_OAK_SAPLING = BWGWood.createNonSetSapling("brown_oak", BWGTreeGrowers.BROWN_OAK, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock BROWN_ZELKOVA_SAPLING = BWGWood.createNonSetSapling("brown_zelkova", BWGTreeGrowers.BROWN_ZELKOVA, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock INDIGO_JACARANDA_SAPLING = BWGWood.createNonSetSapling("indigo_jacaranda", BWGTreeGrowers.INDIGO_JACARANDA, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock ORANGE_BIRCH_SAPLING = BWGWood.createNonSetSapling("orange_birch", BWGTreeGrowers.ORANGE_BIRCH, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock ORANGE_OAK_SAPLING = BWGWood.createNonSetSapling("orange_oak", BWGTreeGrowers.ORANGE_OAK, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock ORANGE_SPRUCE_SAPLING = BWGWood.createNonSetSapling("orange_spruce", BWGTreeGrowers.ORANGE_SPRUCE, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock ORCHARD_SAPLING = BWGWood.createNonSetSapling("orchard", BWGTreeGrowers.ORCHARD, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock RED_BIRCH_SAPLING = BWGWood.createNonSetSapling("red_birch", BWGTreeGrowers.RED_BIRCH, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock RED_MAPLE_SAPLING = BWGWood.createNonSetSapling("red_maple", BWGTreeGrowers.RED_MAPLE, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock RED_OAK_SAPLING = BWGWood.createNonSetSapling("red_oak", BWGTreeGrowers.RED_OAK, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock RED_SPRUCE_SAPLING = BWGWood.createNonSetSapling("red_spruce", BWGTreeGrowers.RED_SPRUCE, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock SILVER_MAPLE_SAPLING = BWGWood.createNonSetSapling("silver_maple", BWGTreeGrowers.SILVER_MAPLE, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock YELLOW_BIRCH_SAPLING = BWGWood.createNonSetSapling("yellow_birch", BWGTreeGrowers.YELLOW_BIRCH, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock YELLOW_SPRUCE_SAPLING = BWGWood.createNonSetSapling("yellow_spruce", BWGTreeGrowers.YELLOW_SPRUCE, (TagKey<Block>)BlockTags.f_144274_);
    public static final PottedBlock YUCCA_SAPLING = BWGWood.createNonSetSapling("yucca", BWGTreeGrowers.YUCCA, (TagKey<Block>)BlockTags.f_13029_);
    public static final Supplier<LeavesBlock> ARAUCARIA_LEAVES = BWGWood.registerFloweringLeaves("araucaria");
    public static final Supplier<LeavesBlock> RIPE_BAOBAB_LEAVES = BWGWood.registerFruitLeaves("ripe_baobab", BWGBlocks.BAOBAB_FRUIT_BLOCK, 0.04f);
    public static final Supplier<LeavesBlock> FLOWERING_BAOBAB_LEAVES = BWGWood.registerChangingLeaves("flowering_baobab", RIPE_BAOBAB_LEAVES, 0.02f);
    public static final Supplier<LeavesBlock> BLUE_SPRUCE_LEAVES = BWGWood.registerFloweringLeaves("blue_spruce");
    public static final Supplier<LeavesBlock> BLOOMING_WITCH_HAZEL_LEAVES = BWGWood.registerGlowingLeaves("blooming_witch_hazel");
    public static final Supplier<LeavesBlock> BROWN_BIRCH_LEAVES = BWGWood.registerFloweringLeaves("brown_birch");
    public static final Supplier<LeavesBlock> BROWN_OAK_LEAVES = BWGWood.registerFloweringLeaves("brown_oak");
    public static final Supplier<LeavesBlock> BROWN_ZELKOVA_LEAVES = BWGWood.registerFloweringLeaves("brown_zelkova");
    public static final Supplier<LeavesBlock> RIPE_ORCHARD_LEAVES = BWGWood.registerFruitLeaves("ripe_orchard", BWGBlocks.APPLE_FRUIT_BLOCK, 0.04f);
    public static final Supplier<LeavesBlock> FLOWERING_ORCHARD_LEAVES = BWGWood.registerChangingLeaves("flowering_orchard", RIPE_ORCHARD_LEAVES, 0.02f);
    public static final Supplier<LeavesBlock> FLOWERING_PALO_VERDE_LEAVES = BWGWood.registerFloweringLeaves("flowering_palo_verde", () -> ParticleTypes.f_175833_);
    public static final Supplier<LeavesBlock> HOLLY_BERRY_LEAVES = BWGWood.registerFloweringLeaves("holly_berry");
    public static final Supplier<LeavesBlock> INDIGO_JACARANDA_LEAVES = BWGWood.registerFloweringLeaves("indigo_jacaranda");
    public static final Supplier<LeavesBlock> FLOWERING_JACARANDA_LEAVES = BWGWood.registerFloweringLeaves("flowering_jacaranda");
    public static final Supplier<LeavesBlock> FLOWERING_INDIGO_JACARANDA_LEAVES = BWGWood.registerFloweringLeaves("flowering_indigo_jacaranda");
    public static final Supplier<LeavesBlock> YUCCA_LEAVES = BWGWood.registerFloweringLeaves("yucca");
    public static final Supplier<LeavesBlock> RIPE_YUCCA_LEAVES = BWGWood.registerFruitLeaves("ripe_yucca", BWGBlocks.YUCCA_FRUIT_BLOCK, 0.04f);
    public static final Supplier<LeavesBlock> FLOWERING_YUCCA_LEAVES = BWGWood.registerChangingLeaves("flowering_yucca", RIPE_YUCCA_LEAVES, 0.02f);
    public static final Supplier<LeavesBlock> ORANGE_BIRCH_LEAVES = BWGWood.registerFloweringLeaves("orange_birch");
    public static final Supplier<LeavesBlock> ORANGE_OAK_LEAVES = BWGWood.registerFloweringLeaves("orange_oak");
    public static final Supplier<LeavesBlock> ORANGE_SPRUCE_LEAVES = BWGWood.registerFloweringLeaves("orange_spruce");
    public static final Supplier<LeavesBlock> ORCHARD_LEAVES = BWGWood.registerFloweringLeaves("orchard");
    public static final Supplier<LeavesBlock> RED_BIRCH_LEAVES = BWGWood.registerFloweringLeaves("red_birch");
    public static final Supplier<LeavesBlock> RED_MAPLE_LEAVES = BWGWood.registerFloweringLeaves("red_maple", BWGParticles.RED_MAPLE_LEAVES);
    public static final Supplier<LeavesBlock> RED_OAK_LEAVES = BWGWood.registerFloweringLeaves("red_oak");
    public static final Supplier<LeavesBlock> RED_SPRUCE_LEAVES = BWGWood.registerFloweringLeaves("red_spruce");
    public static final Supplier<LeavesBlock> SILVER_MAPLE_LEAVES = BWGWood.registerFloweringLeaves("silver_maple", BWGParticles.SILVER_MAPLE_LEAVES);
    public static final Supplier<LeavesBlock> SKYRIS_LEAVES_GREEN_APPLE = BWGWood.registerFruitLeaves("green_apple_skyris", BWGBlocks.GREEN_APPLE_FRUIT_BLOCK, 0.04f);
    public static final Supplier<LeavesBlock> FLOWERING_SKYRIS_LEAVES = BWGWood.registerChangingLeaves("flowering_skyris", SKYRIS_LEAVES_GREEN_APPLE, 0.02f);
    public static final Supplier<LeavesBlock> FLOWERING_IRONWOOD_LEAVES = BWGWood.registerFloweringLeaves("flowering_ironwood", BWGParticles.IRONWOOD_LEAVES);
    public static final Supplier<LeavesBlock> WHITE_SAKURA_LEAVES = BWGWood.registerSakuraLeaves("white_sakura", BWGParticles.WHITE_SAKURA_LEAVES);
    public static final Supplier<LeavesBlock> YELLOW_SAKURA_LEAVES = BWGWood.registerSakuraLeaves("yellow_sakura", BWGParticles.YELLOW_SAKURA_LEAVES);
    public static final Supplier<LeavesBlock> YELLOW_BIRCH_LEAVES = BWGWood.registerFloweringLeaves("yellow_birch");
    public static final Supplier<LeavesBlock> YELLOW_SPRUCE_LEAVES = BWGWood.registerFloweringLeaves("yellow_spruce");
    public static final Supplier<LeavesBlock> FIRECRACKER_LEAVES = BWGWood.registerNonSetBlockItem("firecracker_leaves", () -> new BWGFireCrackerLeaves(BWGWood.leaves()));

    private static Supplier<LeavesBlock> registerGlowingLeaves(String key) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new LeavesBlock(BWGWood.leaves().m_60953_(state -> 8)));
    }

    private static Supplier<LeavesBlock> registerFloweringLeaves(String key) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> Blocks.m_152614_((SoundType)SoundType.f_56740_));
    }

    private static Supplier<LeavesBlock> registerFloweringLeaves(String key, Supplier<SimpleParticleType> particleType) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new BWGLeavesBlock(BWGWood.leaves(), particleType));
    }

    private static Supplier<LeavesBlock> registerSakuraLeaves(String key, Supplier<SimpleParticleType> particleType) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new BWGLeavesBlock(BWGWood.leaves().m_60918_(SoundType.f_271239_), particleType));
    }

    private static Supplier<LeavesBlock> registerChangingLeaves(String key, Supplier<LeavesBlock> ripeLeaves, float chance) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new BWGChangingLeavesBlock(BWGWood.leaves(), ripeLeaves, chance));
    }

    private static Supplier<LeavesBlock> registerFruitLeaves(String key, Supplier<BWGFruitBlock> bwgFruitBlockSupplier, float chance) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new BWGFruitLeavesBlock(BWGWood.leaves(), bwgFruitBlockSupplier, chance));
    }

    protected static PottedBlock createNonSetSapling(String key, Supplier<AbstractTreeGrower> grower, TagKey<Block> ground) {
        PottedBlock sapling = BWGWood.createSapling(key, grower, ground);
        NONSET_WOOD.add(sapling.getBlockSupplier());
        NONSET_WOOD.add(sapling.getPottedBlockSupplier());
        return sapling;
    }

    protected static PottedBlock createSapling(String key, Supplier<AbstractTreeGrower> grower, TagKey<Block> ground) {
        Supplier<SaplingBlock> sapling = BWGWood.registerBlockItem(key + "_sapling", () -> new BWGSaplingBlock(ground, (AbstractTreeGrower)grower.get()));
        return new PottedBlock(sapling, BWGWood.register("potted_" + key + "_sapling", PlatformHandler.PLATFORM_HANDLER.createPottedBlock(sapling)));
    }

    private static <B extends Block> Supplier<B> registerNonSetBlockItem(String key, Supplier<B> blockSupplier) {
        Supplier block = BWGWood.register(key, blockSupplier);
        NONSET_WOOD.add(block);
        BWGWood.registerItem(key, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    protected static <B extends Block> Supplier<B> registerBlockItem(String key, Supplier<B> blockSupplier) {
        Supplier block = BWGWood.register(key, blockSupplier);
        BWGWood.registerItem(key, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    protected static <B extends Block> Supplier<B> register(String id, Supplier<B> blockSupplier) {
        Supplier<B> block = BWGBlocks.register(id, blockSupplier);
        WOOD.add(block);
        return block;
    }

    protected static <I extends Item> Supplier<I> registerItem(String id, Supplier<I> item) {
        Supplier<I> supplier = BWGItems.register(id, item);
        WOOD_BLOCK_ITEMS.add(supplier);
        return supplier;
    }

    private static BlockBehaviour.Properties leaves() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(Blocks::m_50821_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_(Blocks::m_50805_);
    }

    public static void wood() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone Wood");
    }
}

