/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.dyenamics.Dyenamics;
import cy.jdkdigital.dyenamics.common.blockentity.DyenamicShulkerBoxBlockEntity;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DyenamicShulkerBoxBlockEntityRenderer
implements BlockEntityRenderer<DyenamicShulkerBoxBlockEntity> {
    private final ShulkerModel<?> model;

    public DyenamicShulkerBoxBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.model = new ShulkerModel(pContext.bakeLayer(ModelLayers.SHULKER));
    }

    public void render(DyenamicShulkerBoxBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockState blockstate;
        Direction direction = Direction.UP;
        if (pBlockEntity.hasLevel() && (blockstate = pBlockEntity.getLevel().getBlockState(pBlockEntity.getBlockPos())).getBlock() instanceof ShulkerBoxBlock) {
            direction = (Direction)blockstate.getValue((Property)ShulkerBoxBlock.FACING);
        }
        DyenamicDyeColor dyecolor = pBlockEntity.getDyenamicColor();
        Material material = Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION;
        if (dyecolor != null && Dyenamics.SHULKER_MATERIAL_MAP.containsKey(dyecolor.getSerializedName())) {
            material = Dyenamics.SHULKER_MATERIAL_MAP.get(dyecolor.getSerializedName());
        }
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.5, 0.5);
        pPoseStack.scale(0.9995f, 0.9995f, 0.9995f);
        pPoseStack.mulPose(direction.getRotation());
        pPoseStack.scale(1.0f, -1.0f, -1.0f);
        pPoseStack.translate(0.0, -1.0, 0.0);
        ModelPart modelpart = this.model.getLid();
        modelpart.setPos(0.0f, 24.0f - pBlockEntity.getProgress(pPartialTick) * 0.5f * 16.0f, 0.0f);
        modelpart.yRot = 270.0f * pBlockEntity.getProgress(pPartialTick) * ((float)Math.PI / 180);
        VertexConsumer vertexconsumer = material.buffer(pBufferSource, RenderType::entityCutoutNoCull);
        this.model.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay, -1);
        pPoseStack.popPose();
    }
}

