/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModUtils {
    public static void addStrippable(Block block, Block strippedBlock) {
        AxeItem.STRIPPABLES = Maps.newHashMap((Map)AxeItem.STRIPPABLES);
        AxeItem.STRIPPABLES.put(block, strippedBlock);
    }

    public static boolean hasBlockEnoughSolidSite(VoxelShape shape, LevelReader world, BlockPos pos, Direction direction) {
        BlockState state = world.getBlockState(pos);
        if (direction == Direction.DOWN && state.is(BlockTags.UNSTABLE_BOTTOM_CENTER)) {
            return false;
        }
        return !Shapes.joinIsNotEmpty((VoxelShape)state.getBlockSupportShape((BlockGetter)world, pos).getFaceShape(direction), (VoxelShape)shape, (BooleanOp)BooleanOp.ONLY_SECOND);
    }

    public static Vec3 blockPosToVector(BlockPos pos) {
        return ModUtils.blockPosToVector(pos, 0.0);
    }

    public static Vec3 blockPosToVector(BlockPos pos, double offset) {
        return new Vec3((double)pos.getX() + offset, (double)pos.getY() + offset, (double)pos.getZ() + offset);
    }
}

