/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.util.ModTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class MagicalFarmlandLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<MagicalFarmlandLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> MagicalFarmlandLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, MagicalFarmlandLootModifier::new)));

    public MagicalFarmlandLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        Vec3 pos = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        ServerLevel level = context.getLevel();
        if (state == null || pos == null || !state.is(BlockTags.CROPS) || state.is(ModTags.Blocks.MAGICAL_FARMLAND_BLACKLISTED)) {
            return generatedLoot;
        }
        if (level.getBlockState(BlockPos.containing((Position)pos).below()).is((Block)ModBlocks.MAGICAL_FARMLAND.get())) {
            CropBlock crop;
            Block block = state.getBlock();
            if (block instanceof CropBlock && !(crop = (CropBlock)block).isMaxAge(state)) {
                return generatedLoot;
            }
            generatedLoot.addAll(generatedLoot.stream().filter(stack -> !stack.is(ModTags.Items.MAGICAL_FARMLAND_BLACKLISTED)).toList());
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

