/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.enhancer.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.item.enhancer.condition.EffectCondition;
import com.stal111.forbidden_arcanus.common.item.enhancer.condition.EffectConditionType;
import com.stal111.forbidden_arcanus.core.init.other.ModEnhancerEffectConditions;
import net.minecraft.world.level.Level;

public class TimeCondition
extends EffectCondition {
    public static final MapCodec<TimeCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("start").forGetter(condition -> condition.startTime), (App)Codec.INT.fieldOf("end").forGetter(condition -> condition.endTime)).apply((Applicative)instance, TimeCondition::new));
    private final int startTime;
    private final int endTime;

    public TimeCondition(int startTime, int endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        if (startTime >= endTime) {
            throw new IllegalArgumentException("The ending time needs to be higher than the starting time!");
        }
    }

    @Override
    public boolean test(Level level) {
        long dayTime = level.getDayTime();
        return dayTime >= (long)this.startTime && dayTime <= (long)this.endTime;
    }

    @Override
    public EffectConditionType<? extends EffectCondition> getType() {
        return (EffectConditionType)ModEnhancerEffectConditions.TIME.get();
    }
}

