/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.bucket;

import com.stal111.forbidden_arcanus.common.item.bucket.BucketFamily;
import com.stal111.forbidden_arcanus.common.item.bucket.CapacityFluidBucket;
import com.stal111.forbidden_arcanus.common.item.bucket.CapacityMilkBucketItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class CapacityBucketItem
extends BucketItem
implements CapacityFluidBucket {
    private static final double BURN_CHANCE = 0.005;
    private final Fluid fluid;
    private final BucketFamily family;

    public CapacityBucketItem(Fluid fluid, BucketFamily family, Item.Properties builder) {
        super(fluid, builder);
        this.fluid = fluid;
        this.family = family;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity livingEntity, @NotNull InteractionHand hand) {
        return CapacityMilkBucketItem.tryMilk(stack.copy(), player, livingEntity, hand, this);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isSelected) {
        if (level.isClientSide() || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (this.getFluid().isSame((Fluid)Fluids.LAVA) && level.getRandom().nextDouble() < 0.005 && !livingEntity.hasInfiniteMaterials()) {
            livingEntity.getSlot(slot).set(Items.CHARCOAL.getDefaultInstance());
            level.setBlockAndUpdate(entity.blockPosition(), this.getFluid().defaultFluidState().createLegacyBlock());
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        BlockPos placePos;
        Block block;
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hitResult = CapacityBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid().isSame(Fluids.EMPTY) || !this.isFull(stack) ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = hitResult.getBlockPos();
        Direction direction = hitResult.getDirection();
        BlockPos relativePos = pos.relative(direction);
        if (!level.mayInteract(player, pos) || !player.mayUseItemAt(relativePos, direction, stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack.copyWithCount(1)).orElseThrow(() -> new IllegalStateException("CapacityBucketItem did not have a fluid handler capability!"));
        BlockState state = level.getBlockState(pos);
        FluidState fluid = level.getFluidState(pos);
        boolean isEmpty = this.getFluid().isSame(Fluids.EMPTY);
        if ((isEmpty || !this.isFull(stack)) && (block = state.getBlock()) instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            if (!fluid.isEmpty() || bucketPickup instanceof PowderSnowBlock) {
                ItemStack filledBucket = this.fillBucket(fluidHandlerItem, fluid, bucketPickup, player, level, pos, state);
                return InteractionResultHolder.sidedSuccess((Object)ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)filledBucket), (boolean)level.isClientSide());
            }
        }
        BlockPos blockPos = placePos = this.canBlockContainFluid(player, level, pos, state) ? pos : relativePos;
        if (this.emptyContents(player, level, placePos, hitResult, stack)) {
            this.checkExtraContent(player, level, stack, placePos);
            fluidHandlerItem.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, placePos, stack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            ItemStack result = player.getAbilities().instabuild ? stack : fluidHandlerItem.getContainer();
            return InteractionResultHolder.sidedSuccess((Object)result, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private ItemStack fillBucket(IFluidHandlerItem fluidHandlerItem, FluidState fluid, BucketPickup bucketPickup, Player player, Level level, BlockPos pos, BlockState state) {
        ItemStack filledBucket;
        bucketPickup.pickupBlock(player, (LevelAccessor)level, pos, state);
        if (!fluid.isEmpty() && fluidHandlerItem.isFluidValid(0, new FluidStack(fluid.getType(), 1000))) {
            fluidHandlerItem.fill(new FluidStack(fluid.getType(), 1000), IFluidHandler.FluidAction.EXECUTE);
            filledBucket = fluidHandlerItem.getContainer().copy();
        } else {
            filledBucket = new ItemStack((ItemLike)this.family.powderSnowBucket().get());
        }
        bucketPickup.getPickupSound(state).ifPresent(soundEvent -> player.playSound(soundEvent, 1.0f, 1.0f));
        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.FILLED_BUCKET.trigger(serverPlayer, filledBucket);
        }
        return filledBucket;
    }

    @Override
    public BucketFamily getFamily() {
        return this.family;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }
}

