/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.integration;

import com.stal111.forbidden_arcanus.common.item.crafting.ApplyModifierRecipe;
import com.stal111.forbidden_arcanus.core.init.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.Level;

public class ApplyModifierRecipeMaker {
    public static List<RecipeHolder<SmithingRecipe>> getRecipes() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return Collections.emptyList();
        }
        ArrayList<RecipeHolder<SmithingRecipe>> recipes = new ArrayList<RecipeHolder<SmithingRecipe>>();
        List<RecipeHolder> applyModifierRecipes = level.getRecipeManager().getAllRecipesFor(RecipeType.SMITHING).stream().filter(upgradeRecipe -> ((SmithingRecipe)upgradeRecipe.value()).getSerializer() == ModRecipeSerializers.APPLY_MODIFIER.get()).map(holder -> new RecipeHolder(holder.id(), (Recipe)((ApplyModifierRecipe)holder.value()))).toList();
        for (Item item : BuiltInRegistries.ITEM) {
            ItemStack stack = item.getDefaultInstance();
            for (RecipeHolder recipeHolder : applyModifierRecipes) {
                SmithingRecipeInput input;
                ApplyModifierRecipe recipe = (ApplyModifierRecipe)recipeHolder.value();
                if (!recipe.matches(input = new SmithingRecipeInput(recipe.template().getItems()[0], stack, recipe.addition().getItems()[0]), (Level)level)) continue;
                recipes.add(ApplyModifierRecipeMaker.createRecipe((RecipeHolder<ApplyModifierRecipe>)recipeHolder, input, stack, level.registryAccess()));
            }
        }
        return recipes;
    }

    private static RecipeHolder<SmithingRecipe> createRecipe(RecipeHolder<ApplyModifierRecipe> recipeHolder, SmithingRecipeInput input, ItemStack stack, RegistryAccess registryAccess) {
        ResourceLocation id = recipeHolder.id().withSuffix("_" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath());
        ApplyModifierRecipe recipe = (ApplyModifierRecipe)recipeHolder.value();
        return new RecipeHolder(id, (Recipe)new SmithingTransformRecipe(recipe.template(), Ingredient.of((ItemStack[])new ItemStack[]{stack}), recipe.addition(), recipe.assemble(input, (HolderLookup.Provider)registryAccess)));
    }
}

