/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.pedestal.effect;

import com.stal111.forbidden_arcanus.common.block.entity.PedestalBlockEntity;
import com.stal111.forbidden_arcanus.common.block.pedestal.effect.PedestalEffect;
import com.stal111.forbidden_arcanus.common.block.pedestal.effect.PedestalEffectTrigger;
import java.util.function.BiPredicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryEntry;
import org.jetbrains.annotations.Nullable;

public class SummonEntityEffect<T extends LivingEntity>
extends PedestalEffect {
    private final BiPredicate<ServerLevel, ItemStack> spawnCondition;
    private final RegistryEntry<EntityType<?>, EntityType<T>> entityType;
    private final int spawnRadius;
    private final boolean consumeItem;

    public SummonEntityEffect(BiPredicate<ServerLevel, ItemStack> spawnCondition, RegistryEntry<EntityType<?>, EntityType<T>> entityType, int spawnRadius, boolean consumeItem) {
        super(PedestalEffectTrigger.PLAYER_PLACE_ITEM);
        this.spawnCondition = spawnCondition;
        this.entityType = entityType;
        this.spawnRadius = spawnRadius;
        this.consumeItem = consumeItem;
    }

    @Override
    public void execute(ServerLevel level, BlockPos pos, ItemStack stack) {
        BlockEntity blockEntity;
        LivingEntity entity;
        if (!this.spawnCondition.test(level, stack)) {
            return;
        }
        BlockPos spawnPos = this.findSpawnPositionNear(level, pos, this.spawnRadius);
        if (spawnPos != null && (entity = (LivingEntity)((EntityType)this.entityType.get()).create(level, null, spawnPos, MobSpawnType.MOB_SUMMONED, false, false)) != null) {
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, pos.getCenter());
            level.addFreshEntity((Entity)entity);
        }
        if (this.consumeItem && (blockEntity = level.getBlockEntity(pos)) instanceof PedestalBlockEntity) {
            PedestalBlockEntity blockEntity2 = (PedestalBlockEntity)blockEntity;
            blockEntity2.clearStack(null, PedestalEffectTrigger.ENTITY_SUMMONED);
        }
    }

    @Nullable
    private BlockPos findSpawnPositionNear(ServerLevel level, BlockPos pos, int maxDistance) {
        BlockPos spawnPos = null;
        SpawnPlacementType spawnPlacementType = SpawnPlacements.getPlacementType((EntityType)((EntityType)this.entityType.get()));
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.getX() + level.getRandom().nextInt(maxDistance * 2) - maxDistance;
            BlockPos blockpos1 = new BlockPos(j, l = level.getHeight(Heightmap.Types.WORLD_SURFACE, j, k = pos.getZ() + level.getRandom().nextInt(maxDistance * 2) - maxDistance), k);
            if (!spawnPlacementType.isSpawnPositionOk((LevelReader)level, blockpos1, (EntityType)this.entityType.get())) continue;
            spawnPos = blockpos1;
            break;
        }
        return spawnPos;
    }
}

