/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ForgeDataCache;
import com.stal111.forbidden_arcanus.common.block.entity.forge.circle.MagicCircleType;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualInput;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualRequirements;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.result.RitualResult;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record Ritual(List<RitualInput> inputs, Ingredient mainIngredient, RitualResult result, RitualRequirements requirements, Holder<MagicCircleType> magicCircleType, int duration) {
    public static final int DEFAULT_DURATION = 500;
    public static final Codec<Ritual> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RitualInput.CODEC.listOf(1, 8).fieldOf("inputs").forGetter(ritual -> ritual.inputs), (App)Ingredient.CODEC_NONEMPTY.fieldOf("main_ingredient").forGetter(ritual -> ritual.mainIngredient), (App)RitualResult.DIRECT_CODEC.fieldOf("result").forGetter(ritual -> ritual.result), (App)RitualRequirements.CODEC.forGetter(ritual -> ritual.requirements), (App)MagicCircleType.CODEC.fieldOf("magic_circle").forGetter(ritual -> ritual.magicCircleType), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("duration", (Object)500).forGetter(ritual -> ritual.duration)).apply((Applicative)instance, Ritual::new));
    public static final Codec<Holder<Ritual>> CODEC = RegistryFileCodec.create(FARegistries.RITUAL, DIRECT_CODEC);
    public static final Codec<Ritual> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RitualInput.CODEC.listOf().fieldOf("inputs").forGetter(ritual -> ritual.inputs), (App)Ingredient.CODEC_NONEMPTY.fieldOf("main_ingredient").forGetter(ritual -> ritual.mainIngredient), (App)RitualResult.DIRECT_CODEC.fieldOf("result").forGetter(ritual -> ritual.result), (App)RitualRequirements.CODEC.forGetter(ritual -> ritual.requirements), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("duration", (Object)500).forGetter(ritual -> ritual.duration)).apply((Applicative)instance, (inputs, mainIngredient, result, requirements, duration) -> new Ritual((List<RitualInput>)inputs, (Ingredient)mainIngredient, (RitualResult)result, (RitualRequirements)requirements, null, (int)duration)));

    public boolean canStart(ForgeDataCache dataCache, int forgeTier) {
        if (!this.requirements.checkRequirements(forgeTier, dataCache.getEnhancers())) {
            return false;
        }
        return this.checkIngredients(dataCache.getIngredients(), dataCache.mainIngredient());
    }

    public boolean checkIngredients(Collection<ItemStack> list, ItemStack mainIngredient) {
        if (!this.mainIngredient().test(mainIngredient)) {
            return false;
        }
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(list);
        block0: for (RitualInput input : this.inputs()) {
            int amount = 0;
            Iterator iterator = ingredients.iterator();
            while (iterator.hasNext()) {
                if (!input.ingredient().test((ItemStack)iterator.next())) continue;
                iterator.remove();
                if (++amount != input.amount()) continue;
                continue block0;
            }
            return false;
        }
        return ingredients.stream().filter(stack -> !stack.isEmpty()).toList().isEmpty();
    }
}

