/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.common.block.entity.ArcaneCrystalObeliskBlockEntity;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.block.properties.ObeliskPart;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ArcaneCrystalObeliskBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<ObeliskPart> PART = ModBlockStateProperties.OBELISK_PART;
    public static final BooleanProperty ACTIVE = ModBlockStateProperties.ACTIVE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<ObeliskPart, VoxelShape> SHAPES = (Map)Util.make(new EnumMap(ObeliskPart.class), map -> {
        map.put(ObeliskPart.LOWER, Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)));
        map.put(ObeliskPart.MIDDLE, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        map.put(ObeliskPart.UPPER, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0));
    });

    public ArcaneCrystalObeliskBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)((Object)ObeliskPart.LOWER))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)ACTIVE) != false && state.getValue(PART) == ObeliskPart.LOWER ? new ArcaneCrystalObeliskBlockEntity(pos, state) : null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(PART));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() > level.getMaxBuildHeight() - 3 || !level.getBlockState(pos.above()).canBeReplaced(context) || !level.getBlockState(pos.above(2)).canBeReplaced(context)) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(ArcaneCrystalObeliskBlock.shouldActivate(level, pos)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        ObeliskPart part = (ObeliskPart)((Object)state.getValue(PART));
        if (facing.getAxis() != Direction.Axis.Y) {
            return state;
        }
        if (part == ObeliskPart.LOWER == (facing == Direction.UP) || part == ObeliskPart.MIDDLE) {
            return facingState.is((Block)this) && facingState.getValue(PART) != part ? state : Blocks.AIR.defaultBlockState();
        }
        if (part == ObeliskPart.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!fromPos.equals((Object)pos.below())) {
            return;
        }
        boolean flag = ArcaneCrystalObeliskBlock.shouldActivate(level, pos);
        if ((Boolean)state.getValue((Property)ACTIVE) != flag) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ObeliskPart part;
        if (!(level.isClientSide() || !player.isCreative() && player.hasCorrectToolForDrops(state) || (part = (ObeliskPart)((Object)state.getValue(PART))) == ObeliskPart.LOWER)) {
            BlockPos offsetPos = pos.below(part == ObeliskPart.MIDDLE ? 1 : 2);
            BlockState offsetState = level.getBlockState(offsetPos);
            level.setBlock(offsetPos, offsetState.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, offsetPos, Block.getId((BlockState)offsetState));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)ObeliskPart.MIDDLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above()).getType() == Fluids.WATER)));
        level.setBlockAndUpdate(pos.above(2), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)ObeliskPart.UPPER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above(2)).getType() == Fluids.WATER)));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posDown = pos.below();
        BlockState stateDown = level.getBlockState(posDown);
        if (state.getValue(PART) == ObeliskPart.LOWER) {
            return stateDown.isFaceSturdy((BlockGetter)level, posDown, Direction.UP);
        }
        return stateDown.is((Block)this);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide()) {
            return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.ARCANE_CRYSTAL_OBELISK.get()), ArcaneCrystalObeliskBlockEntity::serverTick);
        }
        return null;
    }

    public static boolean shouldActivate(Level level, BlockPos pos) {
        return level.getBlockState(pos.below()).is((Block)ModBlocks.GILDED_CHISELED_POLISHED_DARKSTONE.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, ACTIVE, WATERLOGGED});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

