/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.model;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.client.animation.QuantumInjectorAnimation;
import com.stal111.forbidden_arcanus.common.block.entity.QuantumInjectorBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class QuantumInjectorModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ForbiddenArcanus.location("quantum_injector"), "main");
    private final ModelPart root;

    public QuantumInjectorModel(EntityModelSet modelSet) {
        this.root = modelSet.bakeLayer(LAYER_LOCATION);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition rune = partDefinition.addOrReplaceChild("rune", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition rotate = rune.addOrReplaceChild("rotate", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        rotate.addOrReplaceChild("rune1", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, -4.0f, -8.0f, 0.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)0.0f, (float)0.0f));
        rotate.addOrReplaceChild("rune2", CubeListBuilder.create().texOffs(0, 24).addBox(0.0f, -4.0f, -8.0f, 0.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-8.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        rotate.addOrReplaceChild("rune3", CubeListBuilder.create().texOffs(0, 32).addBox(0.0f, -4.0f, -8.0f, 0.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        rotate.addOrReplaceChild("rune4", CubeListBuilder.create().texOffs(0, 40).addBox(0.0f, -4.0f, -8.0f, 0.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition zero = partDefinition.addOrReplaceChild("0", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition cube = zero.addOrReplaceChild("cube", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        cube.addOrReplaceChild("bone1", CubeListBuilder.create().texOffs(0, 16).addBox(-9.0f, 1.0f, -9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        cube.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(32, 16).addBox(1.0f, 1.0f, -9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        cube.addOrReplaceChild("bone3", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -9.0f, -9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        cube.addOrReplaceChild("bone4", CubeListBuilder.create().texOffs(32, 0).addBox(1.0f, -9.0f, -9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        cube.addOrReplaceChild("bone5", CubeListBuilder.create().texOffs(0, 16).addBox(1.0f, -9.0f, 1.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        cube.addOrReplaceChild("bone6", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 1.0f, 1.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        cube.addOrReplaceChild("bone7", CubeListBuilder.create().texOffs(32, 16).addBox(-9.0f, -9.0f, 1.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        cube.addOrReplaceChild("bone8", CubeListBuilder.create().texOffs(32, 0).addBox(-9.0f, 1.0f, 1.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@NotNull T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
    }

    public void setupAnim(@Nonnull QuantumInjectorBlockEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.transformAnimation, QuantumInjectorAnimation.TRANSFORM, ageInTicks);
        this.animate(entity.rotateAnimation, QuantumInjectorAnimation.ROTATE, ageInTicks);
    }
}

