/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.client.animation.LostSoulAnimation;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.AbstractLostSoul;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class LostSoulModel
extends HierarchicalModel<AbstractLostSoul> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ForbiddenArcanus.location("lost_soul"), "main");
    private final ModelPart head;

    public LostSoulModel(ModelPart root) {
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)).texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition eyes = head.addOrReplaceChild("eyes", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        eyes.addOrReplaceChild("left", CubeListBuilder.create().texOffs(0, 6).mirror().addBox(-2.0f, -1.0f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.3f)).mirror(false), PartPose.offset((float)3.0f, (float)-1.0f, (float)-4.0f));
        eyes.addOrReplaceChild("right", CubeListBuilder.create().texOffs(0, 6).addBox(-1.0f, -1.0f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-3.0f, (float)-1.0f, (float)-4.0f));
        head.addOrReplaceChild("arml", CubeListBuilder.create().texOffs(34, 17).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 5.0f, 4.0f), PartPose.offset((float)5.0f, (float)1.0f, (float)0.0f));
        head.addOrReplaceChild("armr", CubeListBuilder.create().texOffs(22, 17).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 5.0f, 4.0f), PartPose.offset((float)-5.0f, (float)1.0f, (float)0.0f));
        PartDefinition tail0 = head.addOrReplaceChild("tail0", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -2.0f, 3.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        tail0.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(0, 26).addBox(-1.5f, -1.5f, 2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.5f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    @Nonnull
    public ModelPart root() {
        return this.head;
    }

    public void setupAnim(@Nonnull AbstractLostSoul entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.stillAnimationState, LostSoulAnimation.LOST_SOUL_STILL, ageInTicks);
        this.animate(entity.fearAnimationState, LostSoulAnimation.LOST_SOUL_FEAR, ageInTicks);
    }

    public void renderToBuffer(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

