/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.mixins;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    @Shadow
    protected float lastHurt;

    @Shadow
    public abstract Iterable<ItemStack> getArmorSlots();

    @Inject(method={"playHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurtSound(DamageSource source, CallbackInfo ci) {
        if (this.lastHurt < 10.0f && super.getType() == EntityType.PLAYER) {
            for (ItemStack stack : this.getArmorSlots()) {
                if (!(stack.getItem() instanceof QuantumArmorBase)) continue;
                ci.cancel();
                return;
            }
        }
    }

    protected MixinLivingEntity(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }
}

