/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui.advpatternprovider;

import appeng.api.client.AEKeyRendering;
import appeng.api.config.LockCraftingMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.core.localization.GuiText;
import appeng.core.localization.InGameTooltip;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.pedroksl.advanced_ae.client.gui.SmallAdvPatternProviderScreen;
import net.pedroksl.advanced_ae.gui.advpatternprovider.SmallAdvPatternProviderMenu;
import org.jetbrains.annotations.Nullable;

public class SmallAdvPatternProviderLockReason
implements ICompositeWidget {
    protected boolean visible = false;
    protected int x;
    protected int y;
    private final SmallAdvPatternProviderScreen gui;

    public SmallAdvPatternProviderLockReason(SmallAdvPatternProviderScreen gui) {
        this.gui = gui;
    }

    public void setPosition(Point position) {
        this.x = position.getX();
        this.y = position.getY();
    }

    public void setSize(int width, int height) {
    }

    public Rect2i getBounds() {
        return new Rect2i(this.x, this.y, 126, 16);
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        MutableComponent lockStatusText;
        Icon icon;
        SmallAdvPatternProviderMenu menu = (SmallAdvPatternProviderMenu)this.gui.getMenu();
        if (menu.getCraftingLockedReason() == LockCraftingMode.NONE) {
            icon = Icon.UNLOCKED;
            lockStatusText = GuiText.CraftingLockIsUnlocked.text().withStyle(ChatFormatting.DARK_GREEN);
        } else {
            icon = Icon.LOCKED;
            lockStatusText = GuiText.CraftingLockIsLocked.text().withStyle(ChatFormatting.DARK_RED);
        }
        icon.getBlitter().dest(this.x, this.y).blit(guiGraphics);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)lockStatusText, this.x + 15, this.y + 5, -1, false);
    }

    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        SmallAdvPatternProviderMenu menu = (SmallAdvPatternProviderMenu)this.gui.getMenu();
        MutableComponent tooltip = switch (menu.getCraftingLockedReason()) {
            default -> throw new MatchException(null, null);
            case LockCraftingMode.NONE -> null;
            case LockCraftingMode.LOCK_UNTIL_PULSE -> InGameTooltip.CraftingLockedUntilPulse.text();
            case LockCraftingMode.LOCK_WHILE_HIGH -> InGameTooltip.CraftingLockedByRedstoneSignal.text();
            case LockCraftingMode.LOCK_WHILE_LOW -> InGameTooltip.CraftingLockedByLackOfRedstoneSignal.text();
            case LockCraftingMode.LOCK_UNTIL_RESULT -> {
                MutableComponent stackAmount;
                MutableComponent stackName;
                GenericStack stack = menu.getUnlockStack();
                if (stack != null) {
                    stackName = AEKeyRendering.getDisplayName((AEKey)stack.what());
                    stackAmount = Component.literal((String)stack.what().formatAmount(stack.amount(), AmountFormat.FULL));
                } else {
                    stackName = Component.literal((String)"ERROR");
                    stackAmount = Component.literal((String)"ERROR");
                }
                yield InGameTooltip.CraftingLockedUntilResult.text(new Object[]{stackName, stackAmount});
            }
        };
        return tooltip != null ? new Tooltip(new Component[]{tooltip}) : null;
    }
}

