/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.renderer;

import appeng.api.inventories.InternalInventory;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.entities.ReactionChamberEntity;
import org.joml.Quaternionf;

public class ReactionChamberTESR
implements BlockEntityRenderer<ReactionChamberEntity> {
    private final BlockEntityRendererProvider.Context context;
    private static final float ITEM_RENDER_SCALE = 0.4f;
    private static final float L = 0.125f;
    private static final float R = 0.875f;
    private static final float T = 0.6875f;
    private static final float B = 0.125f;
    private static final float FR = 0.125f;
    private static final float BA = 0.875f;
    private static final float[] QUADS = new float[]{0.125f, 0.6875f, 0.125f, 0.875f, 0.125f, 0.125f, 0.875f, 0.6875f, 0.125f, 0.875f, 0.125f, 0.875f, 0.125f, 0.6875f, 0.875f, 0.125f, 0.125f, 0.125f, 0.875f, 0.6875f, 0.875f, 0.125f, 0.125f, 0.875f, 0.125f, 0.6875f, 0.875f, 0.875f, 0.6875f, 0.125f};
    public static RelativeSide[] SIDES = new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP};

    public ReactionChamberTESR(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    @ParametersAreNonnullByDefault
    public void render(ReactionChamberEntity be, float v, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        if (!AAEConfig.instance().getEnableEffects()) {
            return;
        }
        FluidStack fluidStack = be.getFluidStack();
        if (fluidStack == null || fluidStack.isEmpty()) {
            return;
        }
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = be.getBlockPos();
        FluidState state = fluidStack.getFluid().defaultFluidState();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation texture = fluidTypeExtensions.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
        int tintColor = fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)level, pos);
        VertexConsumer buffer = buffers.getBuffer(Sheets.translucentCullBlockSheet());
        BlockOrientation orientation = be.getOrientation();
        for (int x = 0; x < QUADS.length; x += 6) {
            float x0 = QUADS[x];
            float y0 = QUADS[x + 1];
            float z0 = QUADS[x + 2];
            float x1 = QUADS[x + 3];
            float y1 = QUADS[x + 4];
            float z1 = QUADS[x + 5];
            Direction face = orientation.getSide(SIDES[x / 6]);
            poseStack.pushPose();
            ReactionChamberTESR.drawQuad(buffer, poseStack, x0, y0, z0, x1, y1, z1, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), light, overlay, tintColor, face);
            poseStack.popPose();
        }
        InternalInventory inv = be.getInput();
        for (int x = 0; x < inv.size(); ++x) {
            ItemStack stack = inv.getStackInSlot(x);
            if (stack.isEmpty()) continue;
            this.renderItem(poseStack, stack, x, buffers, light, overlay);
        }
    }

    private static void drawQuad(VertexConsumer buffer, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int light, int overlay, int color, Direction front) {
        if (front != Direction.UP && front != Direction.DOWN) {
            ReactionChamberTESR.drawVertex(buffer, poseStack, x0, y0, z0, u0, v0, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x1, y0, z1, u0, v1, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x1, y1, z1, u1, v1, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x0, y1, z0, u1, v0, front, light, overlay, color);
        } else {
            ReactionChamberTESR.drawVertex(buffer, poseStack, x0, y0, z0, u0, v0, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x1, y1, z0, u0, v1, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x1, y1, z1, u1, v1, front, light, overlay, color);
            ReactionChamberTESR.drawVertex(buffer, poseStack, x0, y0, z1, u1, v0, front, light, overlay, color);
        }
    }

    private static void drawVertex(VertexConsumer buffer, PoseStack poseStack, float x, float y, float z, float u, float v, Direction front, int light, int overlay, int color) {
        buffer.addVertex(poseStack.last().pose(), x, y, z).setColor(color).setUv(u, v).setOverlay(overlay).setLight(light);
        ReactionChamberTESR.setNormal(buffer, poseStack, front);
    }

    private void renderItem(PoseStack ms, ItemStack stack, int index, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        if (!stack.isEmpty()) {
            ms.pushPose();
            float duration = 10000.0f;
            long t = System.currentTimeMillis() % (long)((int)duration);
            float angle = (float)t / (duration / 360.0f) + (float)(index * 120);
            ms.rotateAround(new Quaternionf().rotationY((float)Math.PI / 180 * angle), 0.5f, 0.0f, 0.5f);
            float yOffset = ReactionChamberTESR.itemYPosition(t, duration) / 12.0f;
            ms.translate(0.25, 0.5875 + (double)yOffset, 0.5);
            ms.scale(0.4f, 0.4f, 0.4f);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            itemRenderer.renderStatic(stack, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, ms, buffers, (Level)Minecraft.getInstance().level, 0);
            ms.popPose();
        }
    }

    private static void setNormal(VertexConsumer buffer, PoseStack poseStack, Direction front) {
        buffer.setNormal(poseStack.last(), (float)front.getStepX(), (float)front.getStepY(), (float)front.getStepZ());
    }

    private static float itemYPosition(long x, float max) {
        float rad = (float)(x * 2L) * (float)Math.PI / max;
        return Mth.cos((float)rad);
    }
}

