/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.basics.option;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mrbysco.constructionstick.api.IStickTemplate;
import mrbysco.constructionstick.basics.ReplacementRegistry;
import mrbysco.constructionstick.basics.option.IOption;
import mrbysco.constructionstick.basics.option.OptionBoolean;
import mrbysco.constructionstick.basics.option.OptionEnum;
import mrbysco.constructionstick.basics.option.StickUpgradesSelectable;
import mrbysco.constructionstick.items.template.UpgradeDefault;
import mrbysco.constructionstick.registry.ModDataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StickOptions {
    public final ItemStack stickStack;
    public final StickUpgradesSelectable<IStickTemplate> upgrades;
    public final OptionEnum<LOCK> lock;
    public final OptionEnum<DIRECTION> direction;
    public final OptionBoolean replace;
    public final OptionEnum<MATCH> match;
    public final OptionBoolean random;
    public final IOption<?>[] allOptions;

    public StickOptions(ItemStack stickStack) {
        this.stickStack = stickStack;
        this.upgrades = new StickUpgradesSelectable<UpgradeDefault>(stickStack, "upgrades", new UpgradeDefault());
        this.lock = new OptionEnum<LOCK>(stickStack, ModDataComponents.LOCK.get(), "lock", LOCK.class, LOCK.NOLOCK);
        this.direction = new OptionEnum<DIRECTION>(stickStack, ModDataComponents.DIRECTION.get(), "direction", DIRECTION.class, DIRECTION.TARGET);
        this.replace = new OptionBoolean(stickStack, ModDataComponents.REPLACE.get(), "replace", true);
        this.match = new OptionEnum<MATCH>(stickStack, ModDataComponents.MATCH.get(), "match", MATCH.class, MATCH.SIMILAR);
        this.random = new OptionBoolean(stickStack, ModDataComponents.RANDOM.get(), "random", false);
        this.allOptions = new IOption[]{this.upgrades, this.lock, this.direction, this.replace, this.match, this.random};
    }

    @Nullable
    public IOption<?> get(String key) {
        for (IOption<?> option : this.allOptions) {
            if (!option.getKey().equals(key)) continue;
            return option;
        }
        return null;
    }

    public boolean testLock(LOCK l) {
        if (this.lock.get() == LOCK.NOLOCK) {
            return true;
        }
        return this.lock.get() == l;
    }

    public boolean matchBlocks(Block b1, Block b2) {
        switch (((MATCH)((Object)this.match.get())).ordinal()) {
            case 0: {
                return b1 == b2;
            }
            case 1: {
                return ReplacementRegistry.matchBlocks(b1, b2);
            }
            case 2: {
                return b1 != Blocks.AIR && b2 != Blocks.AIR;
            }
        }
        return false;
    }

    public static enum LOCK implements StringRepresentable
    {
        HORIZONTAL(0),
        VERTICAL(1),
        NORTHSOUTH(2),
        EASTWEST(3),
        NOLOCK(4);

        public static final Codec<LOCK> CODEC;
        private static final IntFunction<LOCK> BY_ID;
        public static final StreamCodec<ByteBuf, LOCK> STREAM_CODEC;
        private final int id;

        private LOCK(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(LOCK::values);
            BY_ID = ByIdMap.continuous(LOCK::getId, (Object[])LOCK.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, LOCK::getId);
        }
    }

    public static enum DIRECTION implements StringRepresentable
    {
        TARGET(0),
        PLAYER(1);

        public static final Codec<DIRECTION> CODEC;
        private static final IntFunction<DIRECTION> BY_ID;
        public static final StreamCodec<ByteBuf, DIRECTION> STREAM_CODEC;
        private final int id;

        private DIRECTION(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(DIRECTION::values);
            BY_ID = ByIdMap.continuous(DIRECTION::getId, (Object[])DIRECTION.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, DIRECTION::getId);
        }
    }

    public static enum MATCH implements StringRepresentable
    {
        EXACT(0),
        SIMILAR(1),
        ANY(2);

        public static final Codec<MATCH> CODEC;
        private static final IntFunction<MATCH> BY_ID;
        public static final StreamCodec<ByteBuf, MATCH> STREAM_CODEC;
        private final int id;

        private MATCH(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(MATCH::values);
            BY_ID = ByIdMap.continuous(MATCH::getId, (Object[])MATCH.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, MATCH::getId);
        }
    }
}

