/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick;

import mrbysco.constructionstick.basics.ModStats;
import mrbysco.constructionstick.client.ClientHandler;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.containers.ContainerManager;
import mrbysco.constructionstick.containers.ContainerRegistrar;
import mrbysco.constructionstick.network.ModMessages;
import mrbysco.constructionstick.registry.ModDataComponents;
import mrbysco.constructionstick.registry.ModItems;
import mrbysco.constructionstick.registry.ModRecipes;
import mrbysco.constructionstick.stick.undo.UndoHistory;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="constructionstick")
public class ConstructionStick {
    public static final String MOD_ID = "constructionstick";
    public static final String MODNAME = "ConstructionSticks";
    public static final Logger LOGGER = LogManager.getLogger();
    public static ContainerManager containerManager;
    public static UndoHistory undoHistory;

    public ConstructionStick(IEventBus eventBus, ModContainer container, Dist dist) {
        containerManager = new ContainerManager();
        undoHistory = new UndoHistory();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(ModMessages::registerPayloads);
        eventBus.addListener(ModItems::registerCapabilities);
        ModDataComponents.DATA_COMPONENT_TYPES.register(eventBus);
        ModItems.ITEMS.register(eventBus);
        ModItems.CREATIVE_MODE_TABS.register(eventBus);
        ModStats.CUSTOM_STATS.register(eventBus);
        ModRecipes.RECIPE_SERIALIZERS.register(eventBus);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConstructionConfig.SPEC);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHandler::onClientSetup);
            eventBus.addListener(ClientHandler::registerKeymapping);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ContainerRegistrar.register();
    }

    public static ResourceLocation modLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }
}

