/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.CompassState;
import com.chaosthedude.naturescompass.util.ItemUtils;
import com.chaosthedude.naturescompass.util.PlayerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TeleportPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"naturescompass", (String)"teleport"));
    public static final StreamCodec<FriendlyByteBuf, TeleportPacket> CODEC = StreamCodec.ofMember(TeleportPacket::write, TeleportPacket::read);

    public static TeleportPacket read(FriendlyByteBuf buf) {
        return new TeleportPacket();
    }

    public void write(FriendlyByteBuf buf) {
    }

    public static void handle(TeleportPacket packet, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                ItemStack stack = ItemUtils.getHeldNatureCompass(context.player());
                if (!stack.isEmpty()) {
                    NaturesCompassItem natureCompass = (NaturesCompassItem)stack.getItem();
                    ServerPlayer player = (ServerPlayer)context.player();
                    if (((Boolean)ConfigHandler.GENERAL.allowTeleport.get()).booleanValue() && PlayerUtils.canTeleport(player.getServer(), (Player)player)) {
                        if (natureCompass.getState(stack) == CompassState.FOUND) {
                            int x = natureCompass.getFoundBiomeX(stack);
                            int z = natureCompass.getFoundBiomeZ(stack);
                            int y = packet.findValidTeleportHeight(context.player().level(), x, z);
                            player.stopRiding();
                            player.connection.teleport((double)x, (double)y, (double)z, player.getYRot(), player.getXRot());
                            if (!player.isFallFlying()) {
                                player.setDeltaMovement(player.getDeltaMovement().x(), 0.0, player.getDeltaMovement().z());
                                player.setOnGround(true);
                            }
                        }
                    } else {
                        NaturesCompass.LOGGER.warn("Player " + player.getDisplayName().getString() + " tried to teleport but does not have permission.");
                    }
                }
            });
        }
    }

    private int findValidTeleportHeight(Level level, int x, int z) {
        int upY = level.getSeaLevel();
        int downY = level.getSeaLevel();
        while (!(level.isOutsideBuildHeight(upY) && level.isOutsideBuildHeight(downY) || this.isValidTeleportPosition(level, new BlockPos(x, upY, z)) || this.isValidTeleportPosition(level, new BlockPos(x, downY, z)))) {
            ++upY;
            --downY;
        }
        BlockPos upPos = new BlockPos(x, upY, z);
        BlockPos downPos = new BlockPos(x, downY, z);
        if (this.isValidTeleportPosition(level, upPos)) {
            return upY;
        }
        if (this.isValidTeleportPosition(level, downPos)) {
            return downY;
        }
        return 256;
    }

    private boolean isValidTeleportPosition(Level level, BlockPos pos) {
        return this.isFree(level, pos) && this.isFree(level, pos.above()) && !this.isFree(level, pos.below());
    }

    private boolean isFree(Level level, BlockPos pos) {
        return level.getBlockState(pos).isAir() || level.getBlockState(pos).is(BlockTags.FIRE) || level.getBlockState(pos).liquid() || level.getBlockState(pos).canBeReplaced();
    }

    public CustomPacketPayload.Type<TeleportPacket> type() {
        return TYPE;
    }
}

