/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class BiomeReplacementProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final MapCodec<BiomeReplacementProcessor> CODEC = MapCodec.unit(BiomeReplacementProcessor::new);
    private static final Map<ResourceKey<Biome>, Map<Block, Block>> BIOME_REPLACEMENT_MAP = new HashMap<ResourceKey<Biome>, Map<Block, Block>>();
    private static final Map<ResourceKey<Biome>, Map<Block, Block>> BIOME_SOIL_REPLACEMENT_MAP = new HashMap<ResourceKey<Biome>, Map<Block, Block>>();
    private static final Set<Block> REPLACEABLE_BLOCKS = new HashSet<Block>();

    @SafeVarargs
    private static void addReplacements(Pair<Block, List<ResourceKey<Biome>>> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            Pair<Block, List<ResourceKey<Biome>>> entry = entries[i];
            for (ResourceKey biome : (List)entry.getSecond()) {
                BIOME_REPLACEMENT_MAP.computeIfAbsent((ResourceKey<Biome>)biome, o -> new HashMap());
                REPLACEABLE_BLOCKS.add((Block)entry.getFirst());
                for (int j = 0; j < entries.length; ++j) {
                    if (i == j || entries[j].getFirst() == entry.getFirst() || entries[j].getFirst() == null) continue;
                    BIOME_REPLACEMENT_MAP.get(biome).put((Block)entries[j].getFirst(), (Block)entry.getFirst());
                }
            }
        }
    }

    @SafeVarargs
    private static void addSoilReplacements(Pair<Block, List<ResourceKey<Biome>>> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            Pair<Block, List<ResourceKey<Biome>>> entry = entries[i];
            for (ResourceKey biome : (List)entry.getSecond()) {
                BIOME_SOIL_REPLACEMENT_MAP.computeIfAbsent((ResourceKey<Biome>)biome, o -> new HashMap());
                REPLACEABLE_BLOCKS.add((Block)entry.getFirst());
                for (int j = 0; j < entries.length; ++j) {
                    if (i == j || entries[j].getFirst() == entry.getFirst() || entries[j].getFirst() == null) continue;
                    BIOME_SOIL_REPLACEMENT_MAP.get(biome).put((Block)entries[j].getFirst(), (Block)entry.getFirst());
                }
            }
        }
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        BlockState newState;
        BlockInstance blockAbove;
        BlockState originalState = block.state();
        if (originalState == null || originalState.is(Blocks.AIR) || !REPLACEABLE_BLOCKS.contains(originalState.getBlock())) {
            return block;
        }
        BoundingBox boundingBox = placeSettings.getBoundingBox();
        if (boundingBox == null) {
            return block;
        }
        Holder biomeHolder = level.getBiome(structurePosition);
        if (!biomeHolder.isBound()) {
            return block;
        }
        ResourceKey biome = (ResourceKey)biomeHolder.unwrapKey().get();
        Map<Block, Block> replacements = BIOME_SOIL_REPLACEMENT_MAP.get(biome);
        if (!(replacements != null && replacements.containsKey(originalState.getBlock()) && !((blockAbove = pieceBlocks.get(pos.above())) != null && blockAbove.state() != null ? blockAbove.state() : level.getBlockState(pos.above())).isFaceSturdy((BlockGetter)level, pos.above(), Direction.DOWN) || (replacements = BIOME_REPLACEMENT_MAP.get(biome)) != null && replacements.containsKey(originalState.getBlock()))) {
            return block;
        }
        return new BlockInstance(newState, (newState = replacements.get(originalState.getBlock()).withPropertiesOf(originalState)).is(block.state().getBlock()) ? block.nbt() : null);
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)FormationsStructures.BIOME_REPLACEMENT_PROCESSOR.get();
    }

    static {
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_PLANKS, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_PLANKS, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_PLANKS, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_PLANKS, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_PLANKS, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_PLANKS, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_PLANKS, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_PLANKS, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_PLANKS, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_PLANKS, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_PLANKS, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_STAIRS, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_STAIRS, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_STAIRS, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_STAIRS, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_STAIRS, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_STAIRS, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_STAIRS, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_STAIRS, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_STAIRS, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_STAIRS, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_STAIRS, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_SLAB, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_SLAB, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_SLAB, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_SLAB, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_SLAB, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_SLAB, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_SLAB, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_SLAB, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_SLAB, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_SLAB, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_SLAB, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_LOG, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_LOG, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_LOG, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_LOG, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_LOG, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_LOG, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_LOG, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_BLOCK, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_LOG, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_STEM, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_STEM, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_WOOD, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_WOOD, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_WOOD, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_WOOD, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_WOOD, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_WOOD, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_WOOD, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_BLOCK, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_WOOD, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_HYPHAE, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_HYPHAE, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.STRIPPED_OAK_LOG, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.STRIPPED_SPRUCE_LOG, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.STRIPPED_MANGROVE_LOG, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.STRIPPED_BIRCH_LOG, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.STRIPPED_DARK_OAK_LOG, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.STRIPPED_ACACIA_LOG, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.STRIPPED_JUNGLE_LOG, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.STRIPPED_BAMBOO_BLOCK, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.STRIPPED_CHERRY_LOG, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.STRIPPED_CRIMSON_STEM, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.STRIPPED_WARPED_STEM, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.STRIPPED_OAK_WOOD, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.STRIPPED_SPRUCE_WOOD, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.STRIPPED_MANGROVE_WOOD, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.STRIPPED_BIRCH_WOOD, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.STRIPPED_DARK_OAK_WOOD, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.STRIPPED_ACACIA_WOOD, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.STRIPPED_JUNGLE_WOOD, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.STRIPPED_BAMBOO_BLOCK, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.STRIPPED_CHERRY_WOOD, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.STRIPPED_CRIMSON_HYPHAE, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.STRIPPED_WARPED_HYPHAE, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_LEAVES, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_LEAVES, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_LEAVES, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_LEAVES, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_LEAVES, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_LEAVES, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_LEAVES, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_LEAVES, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.NETHER_WART_BLOCK, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_WART_BLOCK, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_DOOR, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_DOOR, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_DOOR, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_DOOR, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_DOOR, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_DOOR, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_DOOR, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_DOOR, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_DOOR, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_DOOR, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_DOOR, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_TRAPDOOR, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_TRAPDOOR, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_TRAPDOOR, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_TRAPDOOR, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_TRAPDOOR, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_TRAPDOOR, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_TRAPDOOR, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_TRAPDOOR, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_TRAPDOOR, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_TRAPDOOR, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_TRAPDOOR, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_SIGN, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_SIGN, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_SIGN, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_SIGN, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_SIGN, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_SIGN, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_SIGN, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_SIGN, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_SIGN, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_SIGN, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_SIGN, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_WALL_SIGN, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_WALL_SIGN, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_WALL_SIGN, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_WALL_SIGN, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_WALL_SIGN, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_WALL_SIGN, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_WALL_SIGN, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_WALL_SIGN, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_WALL_SIGN, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_WALL_SIGN, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_WALL_SIGN, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_HANGING_SIGN, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_HANGING_SIGN, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_HANGING_SIGN, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_HANGING_SIGN, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_HANGING_SIGN, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_HANGING_SIGN, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_HANGING_SIGN, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_HANGING_SIGN, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_HANGING_SIGN, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_HANGING_SIGN, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_HANGING_SIGN, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_WALL_HANGING_SIGN, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_WALL_HANGING_SIGN, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_WALL_HANGING_SIGN, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_WALL_HANGING_SIGN, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_WALL_HANGING_SIGN, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_WALL_HANGING_SIGN, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_WALL_HANGING_SIGN, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_WALL_HANGING_SIGN, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_WALL_HANGING_SIGN, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_WALL_HANGING_SIGN, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_WALL_HANGING_SIGN, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_FENCE, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_FENCE, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_FENCE, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_FENCE, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_FENCE, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_FENCE, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_FENCE, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_FENCE, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_FENCE, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_FENCE, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FENCE, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_FENCE_GATE, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_FENCE_GATE, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_FENCE_GATE, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_FENCE_GATE, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_FENCE_GATE, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_FENCE_GATE, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_FENCE_GATE, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_FENCE_GATE, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_FENCE_GATE, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_FENCE_GATE, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FENCE_GATE, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_PRESSURE_PLATE, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_PRESSURE_PLATE, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_PRESSURE_PLATE, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_PRESSURE_PLATE, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_PRESSURE_PLATE, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_PRESSURE_PLATE, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_PRESSURE_PLATE, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_PRESSURE_PLATE, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_PRESSURE_PLATE, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_PRESSURE_PLATE, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_PRESSURE_PLATE, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_BUTTON, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_BUTTON, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_BUTTON, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_BUTTON, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_BUTTON, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_BUTTON, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_BUTTON, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_BUTTON, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_BUTTON, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_BUTTON, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_BUTTON, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OAK_SAPLING, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WOODED_BADLANDS, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SPRUCE_SAPLING, List.of(Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN)), Pair.of((Object)Blocks.MANGROVE_PROPAGULE, List.of(Biomes.SWAMP, Biomes.MANGROVE_SWAMP)), Pair.of((Object)Blocks.BIRCH_SAPLING, List.of(Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER)), Pair.of((Object)Blocks.DARK_OAK_SAPLING, List.of(Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN)), Pair.of((Object)Blocks.ACACIA_SAPLING, List.of(Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.DEAD_BUSH, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.JUNGLE_SAPLING, List.of(Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES)), Pair.of((Object)Blocks.BAMBOO_SAPLING, List.of(Biomes.BAMBOO_JUNGLE)), Pair.of((Object)Blocks.CHERRY_SAPLING, List.of(Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST, Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.CHISELED_STONE_BRICKS, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CHISELED_SANDSTONE, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.CHISELED_RED_SANDSTONE, List.of(Biomes.WOODED_BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.CHISELED_DEEPSLATE, List.of(Biomes.DEEP_DARK)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.CRACKED_STONE_BRICKS, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.SMOOTH_SANDSTONE, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.SMOOTH_RED_SANDSTONE, List.of(Biomes.WOODED_BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.CRACKED_DEEPSLATE_BRICKS, List.of(Biomes.DEEP_DARK)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.STONE_BRICKS, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.SANDSTONE, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_SANDSTONE, List.of(Biomes.WOODED_BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.DEEPSLATE_BRICKS, List.of(Biomes.DEEP_DARK)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.STONE_BRICK_STAIRS, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.SANDSTONE_STAIRS, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_SANDSTONE_STAIRS, List.of(Biomes.WOODED_BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.DEEPSLATE_BRICK_STAIRS, List.of(Biomes.DEEP_DARK)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.STONE_BRICK_SLAB, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.SANDSTONE_SLAB, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_SANDSTONE_SLAB, List.of(Biomes.WOODED_BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.DEEPSLATE_BRICK_SLAB, List.of(Biomes.DEEP_DARK)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.STONE_BRICK_WALL, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.SANDSTONE_WALL, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_SANDSTONE_WALL, List.of(Biomes.WOODED_BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.DEEPSLATE_BRICK_WALL, List.of(Biomes.DEEP_DARK)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.SMOOTH_STONE, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CUT_SANDSTONE, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.CUT_RED_SANDSTONE, List.of(Biomes.WOODED_BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.POLISHED_DEEPSLATE, List.of(Biomes.DEEP_DARK)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.SMOOTH_STONE_SLAB, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE)), Pair.of((Object)Blocks.CUT_SANDSTONE_SLAB, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.CUT_RED_SANDSTONE_SLAB, List.of(Biomes.WOODED_BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.POLISHED_DEEPSLATE_SLAB, List.of(Biomes.DEEP_DARK)));
        BiomeReplacementProcessor.addSoilReplacements(Pair.of((Object)Blocks.GRASS_BLOCK, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SAND, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_SAND, List.of(Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.BASALT, List.of(Biomes.BASALT_DELTAS)), Pair.of((Object)Blocks.SOUL_SOIL, List.of(Biomes.SOUL_SAND_VALLEY)), Pair.of((Object)Blocks.NETHERRACK, List.of(Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_NYLIUM, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_NYLIUM, List.of(Biomes.WARPED_FOREST)), Pair.of((Object)Blocks.END_STONE, List.of(Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.DIRT_PATH, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.DESERT, Biomes.BADLANDS, Biomes.ERODED_BADLANDS)), Pair.of((Object)Blocks.SOUL_SAND, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST, Biomes.WARPED_FOREST)), Pair.of((Object)Blocks.END_STONE, List.of(Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.DIRT, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.DEEP_DARK)), Pair.of((Object)Blocks.SAND, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.TERRACOTTA, List.of(Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.WOODED_BADLANDS)), Pair.of((Object)Blocks.BASALT, List.of(Biomes.BASALT_DELTAS)), Pair.of((Object)Blocks.SOUL_SOIL, List.of(Biomes.SOUL_SAND_VALLEY)), Pair.of((Object)Blocks.NETHERRACK, List.of(Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST, Biomes.WARPED_FOREST)), Pair.of((Object)Blocks.END_STONE, List.of(Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.STONE, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.DEEP_DARK, Biomes.DESERT)), Pair.of((Object)Blocks.TERRACOTTA, List.of(Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.WOODED_BADLANDS)), Pair.of((Object)Blocks.BASALT, List.of(Biomes.BASALT_DELTAS)), Pair.of((Object)Blocks.NETHERRACK, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST, Biomes.WARPED_FOREST)), Pair.of((Object)Blocks.END_STONE, List.of(Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.SHORT_GRASS, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.AIR, List.of(Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES, Biomes.SOUL_SAND_VALLEY)), Pair.of((Object)Blocks.CRIMSON_ROOTS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_ROOTS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.SHORT_GRASS, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.DEAD_BUSH, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.AIR, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES, Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.TWISTING_VINES_PLANT, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.DANDELION, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.POPPY, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.BROWN_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.BLUE_ORCHID, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.ALLIUM, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.AZURE_BLUET, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.RED_TULIP, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.ORANGE_TULIP, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT, Biomes.CRIMSON_FOREST, Biomes.WARPED_FOREST)), Pair.of((Object)Blocks.BROWN_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.WHITE_TULIP, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.PINK_TULIP, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.OXEYE_DAISY, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.CORNFLOWER, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.LILY_OF_THE_VALLEY, List.of(Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.FOREST, Biomes.FLOWER_FOREST, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.MEADOW, Biomes.BEACH, Biomes.STONY_SHORE, Biomes.DRIPSTONE_CAVES, Biomes.SNOWY_PLAINS, Biomes.ICE_SPIKES, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.TAIGA, Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_SLOPES, Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS, Biomes.STONY_PEAKS, Biomes.FROZEN_RIVER, Biomes.SNOWY_BEACH, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.SWAMP, Biomes.MANGROVE_SWAMP, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.RIVER, Biomes.DARK_FOREST, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA, Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.LUSH_CAVES, Biomes.BAMBOO_JUNGLE, Biomes.CHERRY_GROVE, Biomes.WOODED_BADLANDS, Biomes.DEEP_DARK, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, Biomes.END_BARRENS)), Pair.of((Object)Blocks.AIR, List.of(Biomes.DESERT)), Pair.of((Object)Blocks.RED_MUSHROOM, List.of(Biomes.SOUL_SAND_VALLEY, Biomes.BASALT_DELTAS, Biomes.NETHER_WASTES)), Pair.of((Object)Blocks.CRIMSON_FUNGUS, List.of(Biomes.CRIMSON_FOREST)), Pair.of((Object)Blocks.WARPED_FUNGUS, List.of(Biomes.WARPED_FOREST)));
    }
}

