/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.worlddata;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public abstract class AbstractWorldData<T extends AbstractWorldData<T>>
extends SavedData {
    protected AbstractWorldData() {
    }

    public void save() {
        this.setDirty();
    }

    @Nonnull
    public static <T extends AbstractWorldData<T>> T getData(Level world, Function<CompoundTag, T> loader, Supplier<T> supplier, String name) {
        if (world.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        DimensionDataStorage storage = LevelTools.getOverworld(world).getDataStorage();
        return (T)((Object)((AbstractWorldData)storage.computeIfAbsent(new SavedData.Factory(supplier, (tag, provider) -> (AbstractWorldData)((Object)((Object)loader.apply((CompoundTag)tag)))), name)));
    }
}

