/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class LevelTools {
    public static boolean isLoaded(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        return world.hasChunkAt(pos);
    }

    public static ServerLevel getOverworld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.getLevel(Level.OVERWORLD);
    }

    public static ServerLevel getOverworld(Level world) {
        MinecraftServer server = world.getServer();
        return server.getLevel(Level.OVERWORLD);
    }

    public static ServerLevel getLevel(ResourceKey<Level> type) {
        return ServerLifecycleHooks.getCurrentServer().getLevel(type);
    }

    public static ServerLevel getLevel(Level world, ResourceKey<Level> type) {
        return world.getServer().getLevel(type);
    }

    public static ServerLevel getLevel(Level world, ResourceLocation id) {
        return world.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id));
    }

    public static ResourceKey<Level> getId(ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
    }

    public static ResourceKey<Level> getId(String id) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)id));
    }

    public static Stream<ServerPlayer> getAllPlayersWatchingBlock(Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ChunkMap playerManager = ((ServerLevel)world).getChunkSource().chunkMap;
            return playerManager.getPlayers(new ChunkPos(pos), false).stream();
        }
        return Stream.empty();
    }
}

