/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.spline;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import mcjty.lib.spline.BSpline;

public class CatmullRomSpline<T>
extends BSpline<T> {
    private int idx;
    private float t;

    @Override
    protected float baseFunction(int i, float t) {
        return switch (i) {
            case -2 -> ((-t + 2.0f) * t - 1.0f) * t / 2.0f;
            case -1 -> ((3.0f * t - 5.0f) * t * t + 2.0f) / 2.0f;
            case 0 -> ((-3.0f * t + 4.0f) * t + 1.0f) * t / 2.0f;
            case 1 -> (t - 1.0f) * t * t / 2.0f;
            default -> 0.0f;
        };
    }

    public CatmullRomSpline(Supplier<T> supplier, BiFunction<T, T, T> subtract, BiFunction<T, T, T> add, BiFunction<T, Float, T> scale) {
        super(supplier, subtract, add, scale);
    }
}

